/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.platform;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.CommandDispatcher;
import hardcorequesting.common.forge.platform.FluidStack;
import hardcorequesting.common.forge.platform.NetworkManager;
import hardcorequesting.common.forge.tileentity.AbstractBarrelBlockEntity;
import hardcorequesting.common.forge.util.Fraction;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.TriConsumer;

public interface AbstractPlatform {
    public Path getConfigDir();

    public NetworkManager getNetworkManager();

    public MinecraftServer getServer();

    public String getModVersion();

    public boolean isClient();

    public void registerOnCommandRegistration(Consumer<CommandDispatcher<CommandSource>> var1);

    public void registerOnWorldLoad(BiConsumer<RegistryKey<World>, ServerWorld> var1);

    public void registerOnWorldSave(Consumer<ServerWorld> var1);

    public void registerOnPlayerJoin(Consumer<ServerPlayerEntity> var1);

    public void registerOnServerTick(Consumer<MinecraftServer> var1);

    @OnlyIn(value=Dist.CLIENT)
    public void registerOnClientTick(Consumer<Minecraft> var1);

    public void registerOnWorldTick(Consumer<World> var1);

    @OnlyIn(value=Dist.CLIENT)
    public void registerOnHudRender(BiConsumer<MatrixStack, Float> var1);

    public void registerOnUseItem(TriConsumer<PlayerEntity, World, Hand> var1);

    public void registerOnBlockPlace(BlockPlaced var1);

    public void registerOnBlockUse(BlockUsed var1);

    public void registerOnBlockBreak(BlockBroken var1);

    public void registerOnItemPickup(BiConsumer<PlayerEntity, ItemStack> var1);

    public void registerOnLivingDeath(BiConsumer<LivingEntity, DamageSource> var1);

    public void registerOnCrafting(BiConsumer<PlayerEntity, ItemStack> var1);

    public void registerOnAnvilCrafting(BiConsumer<PlayerEntity, ItemStack> var1);

    public void registerOnSmelting(BiConsumer<PlayerEntity, ItemStack> var1);

    public void registerOnAdvancement(BiConsumer<ServerPlayerEntity, Advancement> var1);

    public void registerOnAnimalTame(BiConsumer<PlayerEntity, Entity> var1);

    public CompoundNBT getPlayerExtraTag(PlayerEntity var1);

    public ItemGroup createTab(ResourceLocation var1, Supplier<ItemStack> var2);

    public AbstractBlock.Properties createDeliveryBlockProperties();

    public AbstractBarrelBlockEntity createBarrelBlockEntity();

    public void setCraftingRemainingItem(Item var1, Item var2);

    public SaveFormat.LevelSave getStorageSourceOfServer(MinecraftServer var1);

    public FluidStack createEmptyFluidStack();

    public FluidStack createFluidStack(Fluid var1, Fraction var2);

    public FluidStack findFluidIn(ItemStack var1);

    @OnlyIn(value=Dist.CLIENT)
    public void renderFluidStack(FluidStack var1, MatrixStack var2, int var3, int var4, int var5, int var6);

    public Fraction getBucketAmount();

    public Block getBlock(ResourceLocation var1);

    public SoundEvent getSoundEvent(ResourceLocation var1);

    public Item getItem(ResourceLocation var1);

    public TileEntityType<?> getBlockEntity(ResourceLocation var1);

    public void registerBlock(ResourceLocation var1, Supplier<Block> var2);

    public void registerSound(ResourceLocation var1, Supplier<SoundEvent> var2);

    public void registerItem(ResourceLocation var1, Supplier<Item> var2);

    public void registerBlockEntity(ResourceLocation var1, Supplier<TileEntityType<?>> var2);

    public static interface BlockBroken {
        public void onBlockBroken(IWorld var1, BlockPos var2, BlockState var3, PlayerEntity var4);
    }

    public static interface BlockUsed {
        public void onBlockUsed(PlayerEntity var1, World var2, Hand var3, BlockPos var4, Direction var5);
    }

    public static interface BlockPlaced {
        public void onBlockPlaced(World var1, BlockPos var2, BlockState var3, LivingEntity var4);
    }
}

