/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.team.TeamUpdateType;
import hardcorequesting.common.forge.util.SyncUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;

public class TeamUpdateMessage
implements IMessage {
    private TeamUpdateType type;
    private String data;

    public TeamUpdateMessage() {
    }

    public TeamUpdateMessage(TeamUpdateType type, String data) {
        this.type = type;
        this.data = data;
    }

    @Override
    public void fromBytes(PacketBuffer buf, PacketContext context) {
        this.type = TeamUpdateType.values()[buf.readInt()];
        this.data = SyncUtil.readLargeString((ByteBuf)buf);
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.type.ordinal());
        SyncUtil.writeLargeString(this.data, (ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<TeamUpdateMessage, IMessage> {
        @Override
        public IMessage onMessage(TeamUpdateMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(TeamUpdateMessage message, PacketContext ctx) {
            message.type.update(QuestingDataManager.getInstance().getQuestingData(HardcoreQuestingCore.proxy.getPlayer(ctx)).getTeam(), message.data);
        }
    }
}

