/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.ISyncableTile;
import hardcorequesting.common.forge.network.PacketContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SyncableTileMessage
implements IMessage,
IMessageHandler<SyncableTileMessage, IMessage> {
    private TileEntity tileToSync;
    private CompoundNBT data;

    public SyncableTileMessage() {
    }

    public SyncableTileMessage(TileEntity tileToSync) {
        this.tileToSync = tileToSync;
        if (tileToSync instanceof ISyncableTile) {
            this.data = ((ISyncableTile)tileToSync).getSyncData();
        }
    }

    @Override
    public void fromBytes(PacketBuffer buf, PacketContext context) {
        ResourceLocation worldId = buf.func_192575_l();
        BlockPos pos = buf.func_179259_c();
        this.data = buf.func_150793_b();
        ServerWorld world = HardcoreQuestingCore.getServer().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)worldId));
        if (world != null) {
            this.tileToSync = world.func_175625_s(pos);
            System.out.println(this.tileToSync.hashCode());
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.tileToSync.func_145831_w().func_234923_W_().func_240901_a_());
        buf.func_179255_a(this.tileToSync.func_174877_v());
        buf.func_150786_a(this.data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IMessage onMessage(SyncableTileMessage message, PacketContext ctx) {
        ctx.getTaskQueue().accept(() -> {
            if (message.tileToSync instanceof ISyncableTile && message.data != null) {
                System.out.println(message.tileToSync.func_145831_w().func_175625_s(message.tileToSync.func_174877_v()).hashCode());
                ((ISyncableTile)message.tileToSync).onData(message.data);
                System.out.println(message.tileToSync.hashCode());
            }
        });
        return null;
    }
}

