/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.util.SyncUtil;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.network.PacketBuffer;

public class QuestLineSyncMessage
implements IMessage {
    private String reputations;
    private String bags;
    private String mainDescription;
    private Map<String, String> questsSets;

    public QuestLineSyncMessage() {
    }

    public QuestLineSyncMessage(QuestLine questLine) {
        this.mainDescription = questLine.mainDescription;
        this.reputations = questLine.reputationManager.saveToString();
        this.bags = questLine.groupTierManager.saveToString();
        this.questsSets = Maps.newLinkedHashMap();
        for (QuestSet set : questLine.questSetsManager.questSets) {
            this.questsSets.put(set.getFilename(), SaveHandler.save(set, QuestSet.class));
        }
    }

    @Override
    public void fromBytes(PacketBuffer buf, PacketContext context) {
        this.mainDescription = SyncUtil.readLargeString((ByteBuf)buf);
        this.reputations = SyncUtil.readLargeString((ByteBuf)buf);
        this.bags = SyncUtil.readLargeString((ByteBuf)buf);
        int size = buf.readInt();
        this.questsSets = Maps.newLinkedHashMap();
        for (int i = 0; i < size; ++i) {
            String fileName = SyncUtil.readLargeString((ByteBuf)buf);
            String questSetString = SyncUtil.readLargeString((ByteBuf)buf);
            this.questsSets.put(fileName, questSetString);
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        SyncUtil.writeLargeString(this.mainDescription, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.reputations, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.bags, (ByteBuf)buf);
        buf.writeInt(this.questsSets.size());
        for (Map.Entry<String, String> entry : this.questsSets.entrySet()) {
            SyncUtil.writeLargeString(entry.getKey(), (ByteBuf)buf);
            SyncUtil.writeLargeString(entry.getValue(), (ByteBuf)buf);
        }
    }

    public static class Handler
    implements IMessageHandler<QuestLineSyncMessage, IMessage> {
        @Override
        public IMessage onMessage(QuestLineSyncMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(QuestLineSyncMessage message, PacketContext ctx) {
            QuestLine questLine = QuestLine.getActiveQuestLine();
            questLine.provideTemp("description.txt", message.mainDescription);
            questLine.provideTemp(questLine.reputationManager, message.reputations);
            questLine.provideTemp(questLine.groupTierManager, message.bags);
            JsonObject object = new JsonObject();
            JsonArray sets = new JsonArray();
            for (String string : message.questsSets.keySet()) {
                sets.add(string);
            }
            object.add("sets", (JsonElement)sets);
            questLine.provideTemp("sets.json", object.toString());
            for (Map.Entry entry : message.questsSets.entrySet()) {
                questLine.provideTemp("sets/" + (String)entry.getKey() + ".json", (String)entry.getValue());
            }
            questLine.loadAll();
        }
    }
}

