/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.io.adapter.QuestDataAdapter;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.QuestData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;

public class QuestDataUpdateMessage
implements IMessage {
    private UUID questId;
    private String data;
    private int players;

    public QuestDataUpdateMessage() {
    }

    public QuestDataUpdateMessage(UUID questId, int players, QuestData data) {
        this.questId = questId;
        this.data = QuestDataAdapter.QUEST_DATA_ADAPTER.toJson((Object)data);
        this.players = players;
    }

    @Override
    public void fromBytes(PacketBuffer buf, PacketContext context) {
        this.players = buf.readInt();
        this.questId = buf.func_179253_g();
        int charLength = buf.readInt();
        this.data = buf.readCharSequence(charLength, StandardCharsets.UTF_8).toString();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.players);
        buf.func_179252_a(this.questId);
        buf.writeInt(this.data.length());
        buf.writeCharSequence((CharSequence)this.data, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<QuestDataUpdateMessage, IMessage> {
        @Override
        public IMessage onMessage(QuestDataUpdateMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(QuestDataUpdateMessage message, PacketContext ctx) {
            try {
                QuestData data = (QuestData)QuestDataAdapter.QUEST_DATA_ADAPTER.fromJson(message.data);
                Quest quest = Quest.getQuest(message.questId);
                if (quest != null) {
                    quest.setQuestData(HardcoreQuestingCore.proxy.getPlayer(ctx), data);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

