/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.util.SyncUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerDataSyncMessage
implements IMessage {
    private boolean local;
    private boolean remote;
    private boolean questing;
    private boolean hardcore;
    private String teams;
    private String data;
    private String deaths;

    public PlayerDataSyncMessage() {
    }

    public PlayerDataSyncMessage(QuestLine questLine, boolean local, boolean remote, PlayerEntity player) {
        this.local = local;
        this.remote = remote;
        this.questing = questLine.questingDataManager.isQuestActive();
        this.hardcore = questLine.questingDataManager.isHardcoreActive();
        this.teams = questLine.teamManager.saveToString(player);
        this.deaths = questLine.deathStatsManager.saveToString();
        this.data = questLine.questingDataManager.data.saveToString(player);
    }

    @Override
    public void fromBytes(PacketBuffer buf, PacketContext context) {
        this.local = buf.readBoolean();
        this.remote = buf.readBoolean();
        this.questing = buf.readBoolean();
        this.hardcore = buf.readBoolean();
        this.teams = SyncUtil.readLargeString((ByteBuf)buf);
        this.deaths = SyncUtil.readLargeString((ByteBuf)buf);
        this.data = SyncUtil.readLargeString((ByteBuf)buf);
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.local);
        buf.writeBoolean(this.remote);
        buf.writeBoolean(this.questing);
        buf.writeBoolean(this.hardcore);
        SyncUtil.writeLargeString(this.teams, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.deaths, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.data, (ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PlayerDataSyncMessage, IMessage> {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public IMessage onMessage(PlayerDataSyncMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        @OnlyIn(value=Dist.CLIENT)
        private void handle(PlayerDataSyncMessage message, PacketContext ctx) {
            QuestLine.receiveDataFromServer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, message.remote);
            QuestLine questLine = QuestLine.getActiveQuestLine();
            questLine.provideTemp(questLine.teamManager, message.teams);
            questLine.provideTemp(questLine.questingDataManager.data, message.data);
            questLine.provideTemp(questLine.questingDataManager.state, QuestingDataManager.saveQuestingState(message.questing, message.hardcore));
            questLine.provideTemp(questLine.deathStatsManager, message.deaths);
            questLine.loadAll();
        }
    }
}

