/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import hardcorequesting.common.forge.network.GeneralUsage;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class GeneralUpdateMessage
implements IMessage,
IMessageHandler<GeneralUpdateMessage, IMessage> {
    private PlayerEntity player;
    private CompoundNBT data;
    private int usage = -1;

    public GeneralUpdateMessage() {
    }

    public GeneralUpdateMessage(PlayerEntity player, CompoundNBT data, int usage) {
        this.player = player;
        this.data = data;
        this.usage = usage;
    }

    @Override
    public void fromBytes(PacketBuffer buf, PacketContext context) {
        UUID playerId = buf.func_179253_g();
        this.data = buf.func_150793_b();
        this.usage = buf.readInt();
        this.player = context.getPlayer();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.player.func_110124_au());
        buf.func_150786_a(this.data);
        buf.writeInt(this.usage);
    }

    @Override
    public IMessage onMessage(GeneralUpdateMessage message, PacketContext ctx) {
        ctx.getTaskQueue().accept(() -> {
            if (message.data != null && message.usage >= 0) {
                GeneralUsage usage = GeneralUsage.values()[message.usage];
                if (message.player != null) {
                    usage.receiveData(message.player, message.data);
                }
            }
        });
        return null;
    }
}

