/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.util.SyncUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.network.PacketBuffer;

public class FullSyncMessage
implements IMessage {
    private boolean local;
    private boolean questing;
    private boolean hardcore;
    private boolean remote;
    private String timestamp;
    private String reputations;
    private String bags;
    private String teams;
    private String data;
    private String mainDescription;
    private String[] questsSets;
    private String[] questSetNames;

    public FullSyncMessage() {
    }

    public FullSyncMessage(boolean local, boolean remote) {
        this.local = local;
        this.remote = remote;
    }

    public FullSyncMessage(boolean remote) {
        ArrayList names = new ArrayList();
        ArrayList questSets = new ArrayList();
        this.questSetNames = names.toArray(new String[0]);
        this.questsSets = questSets.toArray(new String[0]);
    }

    @Override
    public void fromBytes(PacketBuffer buf, PacketContext context) {
        this.local = buf.readBoolean();
        this.remote = buf.readBoolean();
        this.questing = buf.readBoolean();
        this.hardcore = buf.readBoolean();
        if (this.local) {
            return;
        }
        this.mainDescription = SyncUtil.readLargeString((ByteBuf)buf);
        this.reputations = SyncUtil.readLargeString((ByteBuf)buf);
        this.bags = SyncUtil.readLargeString((ByteBuf)buf);
        this.teams = SyncUtil.readLargeString((ByteBuf)buf);
        this.data = SyncUtil.readLargeString((ByteBuf)buf);
        int size = buf.readInt();
        this.questSetNames = new String[size];
        this.questsSets = new String[size];
        for (int i = 0; i < size; ++i) {
            this.questSetNames[i] = buf.func_150789_c(Short.MAX_VALUE);
            this.questsSets[i] = buf.func_150789_c(Short.MAX_VALUE);
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.local);
        buf.writeBoolean(this.remote);
        buf.writeBoolean(this.questing);
        buf.writeBoolean(this.hardcore);
        if (this.local) {
            return;
        }
        SyncUtil.writeLargeString(this.mainDescription, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.reputations, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.bags, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.teams, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.data, (ByteBuf)buf);
        buf.writeInt(this.questsSets.length);
        for (int i = 0; i < this.questsSets.length; ++i) {
            buf.func_180714_a(this.questSetNames[i]);
            buf.func_180714_a(this.questsSets[i]);
        }
    }

    public static class Handler
    implements IMessageHandler<FullSyncMessage, IMessage> {
        @Override
        public IMessage onMessage(FullSyncMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(FullSyncMessage message, PacketContext ctx) {
            if (!message.local) {
                QuestLine questLine = QuestLine.getActiveQuestLine();
                questLine.provideTemp("description.txt", message.mainDescription);
            }
            QuestLine.receiveDataFromServer(ctx.getPlayer(), message.remote);
        }
    }
}

