/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.death.DeathStat;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.quests.QuestLine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;

public class DeathStatsMessage
implements IMessage {
    private boolean local;
    private Map<UUID, DeathStat> _deathMap;

    public DeathStatsMessage() {
    }

    public DeathStatsMessage(boolean local) {
        this.local = local;
        if (local) {
            DeathStatsManager.getInstance().save();
        }
    }

    @Override
    public void fromBytes(PacketBuffer buf, PacketContext context) {
        this.local = buf.readBoolean();
        if (this.local) {
            return;
        }
        this._deathMap = DeathStatsManager.getInstance().readSimplified(buf);
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.local);
        if (this.local) {
            return;
        }
        DeathStatsManager.getInstance().writeSimplified(buf);
    }

    public static class Handler
    implements IMessageHandler<DeathStatsMessage, IMessage> {
        @Override
        public IMessage onMessage(DeathStatsMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(DeathStatsMessage message, PacketContext ctx) {
            if (!message.local && message._deathMap != null) {
                ArrayList stats = Lists.newArrayList(message._deathMap.values());
                QuestLine.getActiveQuestLine().provideTemp(DeathStatsManager.getInstance(), SaveHandler.save(stats, new TypeToken<List<DeathStat>>(){}.getType()));
            }
            DeathStatsManager.getInstance().load();
        }
    }
}

