/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.tileentity.IBlockSync;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class BlockSyncMessage
implements IMessage {
    private long pos;
    private int type;
    private String data;

    public BlockSyncMessage() {
    }

    public BlockSyncMessage(TileEntity te, int type, String data) {
        this.pos = te.func_174877_v().func_218275_a();
        this.type = type;
        this.data = data;
    }

    @Override
    public void fromBytes(PacketBuffer buf, PacketContext context) {
        this.pos = buf.readLong();
        this.type = buf.readInt();
        this.data = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.pos);
        buf.writeInt(this.type);
        buf.func_180714_a(this.data);
    }

    public static class Handler
    implements IMessageHandler<BlockSyncMessage, IMessage> {
        @Override
        public IMessage onMessage(BlockSyncMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(BlockSyncMessage message, PacketContext ctx) {
            PlayerEntity player = HardcoreQuestingCore.proxy.getPlayer(ctx);
            if (player == null) {
                return;
            }
            TileEntity te = player.field_70170_p.func_175625_s(BlockPos.func_218283_e((long)message.pos));
            JsonObject data = new JsonParser().parse(message.data).getAsJsonObject();
            if (te instanceof IBlockSync) {
                ((IBlockSync)te).readData(player, !ctx.isClient(), message.type, data);
            }
        }
    }
}

