/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network;

import com.google.gson.stream.JsonWriter;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.ISyncableTile;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.network.message.BlockSyncMessage;
import hardcorequesting.common.forge.network.message.BlockSyncMessageClient;
import hardcorequesting.common.forge.network.message.ClientUpdateMessage;
import hardcorequesting.common.forge.network.message.CloseBookMessage;
import hardcorequesting.common.forge.network.message.DeathStatsMessage;
import hardcorequesting.common.forge.network.message.GeneralUpdateMessage;
import hardcorequesting.common.forge.network.message.LivesUpdate;
import hardcorequesting.common.forge.network.message.OpActionMessage;
import hardcorequesting.common.forge.network.message.OpenGuiMessage;
import hardcorequesting.common.forge.network.message.PlayerDataSyncMessage;
import hardcorequesting.common.forge.network.message.QuestDataUpdateMessage;
import hardcorequesting.common.forge.network.message.QuestLineSyncMessage;
import hardcorequesting.common.forge.network.message.SoundMessage;
import hardcorequesting.common.forge.network.message.SyncableTileMessage;
import hardcorequesting.common.forge.network.message.TeamErrorMessage;
import hardcorequesting.common.forge.network.message.TeamMessage;
import hardcorequesting.common.forge.network.message.TeamStatsMessage;
import hardcorequesting.common.forge.network.message.TeamUpdateMessage;
import hardcorequesting.common.forge.tileentity.IBlockSync;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;

public class NetworkManager {
    private static final ResourceLocation S2C = new ResourceLocation("hardcorequesting", "s2c");
    private static final ResourceLocation C2S = new ResourceLocation("hardcorequesting", "c2s");
    private static int id = 0;
    private static final Map<Class<? extends IMessage>, Tuple<Class<? extends IMessageHandler>, Integer>> PACKET_HANDLERS = new HashMap<Class<? extends IMessage>, Tuple<Class<? extends IMessageHandler>, Integer>>();

    public static void init() {
        NetworkManager.registerMessage(OpenGuiMessage.Handler.class, OpenGuiMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(CloseBookMessage.Handler.class, CloseBookMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(QuestLineSyncMessage.Handler.class, QuestLineSyncMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(PlayerDataSyncMessage.Handler.class, PlayerDataSyncMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(TeamStatsMessage.Handler.class, TeamStatsMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(TeamErrorMessage.Handler.class, TeamErrorMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(QuestDataUpdateMessage.Handler.class, QuestDataUpdateMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(DeathStatsMessage.Handler.class, DeathStatsMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(TeamUpdateMessage.Handler.class, TeamUpdateMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(SoundMessage.Handler.class, SoundMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(LivesUpdate.Handler.class, LivesUpdate.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(BlockSyncMessageClient.Handler.class, BlockSyncMessageClient.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(BlockSyncMessage.Handler.class, BlockSyncMessage.class, id++, Dist.DEDICATED_SERVER);
        NetworkManager.registerMessage(TeamMessage.Handler.class, TeamMessage.class, id++, Dist.DEDICATED_SERVER);
        NetworkManager.registerMessage(ClientUpdateMessage.Handler.class, ClientUpdateMessage.class, id++, Dist.DEDICATED_SERVER);
        NetworkManager.registerMessage(OpActionMessage.Handler.class, OpActionMessage.class, id++, Dist.DEDICATED_SERVER);
        NetworkManager.registerMessage(SyncableTileMessage.class, SyncableTileMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(GeneralUpdateMessage.class, GeneralUpdateMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(GeneralUpdateMessage.class, GeneralUpdateMessage.class, id++, Dist.DEDICATED_SERVER);
        if (HardcoreQuestingCore.platform.isClient()) {
            HardcoreQuestingCore.platform.getNetworkManager().registerS2CHandler(S2C, (packetContext, packetByteBuf) -> {
                int id = packetByteBuf.readInt();
                for (Map.Entry<Class<? extends IMessage>, Tuple<Class<? extends IMessageHandler>, Integer>> entry : PACKET_HANDLERS.entrySet()) {
                    if ((Integer)entry.getValue().func_76340_b() != id) continue;
                    try {
                        IMessage message = entry.getKey().newInstance();
                        message.fromBytes((PacketBuffer)packetByteBuf, (PacketContext)packetContext);
                        IMessageHandler handler = entry.getKey() != entry.getValue().func_76341_a() ? (IMessageHandler)((Class)entry.getValue().func_76341_a()).newInstance() : (IMessageHandler)((Object)message);
                        handler.onMessage(message, (PacketContext)packetContext);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                HardcoreQuestingCore.LOGGER.error("Invalid Packet ID: " + id);
            });
        }
        HardcoreQuestingCore.platform.getNetworkManager().registerC2SHandler(C2S, (packetContext, packetByteBuf) -> {
            int id = packetByteBuf.readInt();
            for (Map.Entry<Class<? extends IMessage>, Tuple<Class<? extends IMessageHandler>, Integer>> entry : PACKET_HANDLERS.entrySet()) {
                if ((Integer)entry.getValue().func_76340_b() != id) continue;
                try {
                    IMessage message = entry.getKey().newInstance();
                    message.fromBytes((PacketBuffer)packetByteBuf, (PacketContext)packetContext);
                    IMessageHandler handler = entry.getKey() != entry.getValue().func_76341_a() ? (IMessageHandler)((Class)entry.getValue().func_76341_a()).newInstance() : (IMessageHandler)((Object)message);
                    handler.onMessage(message, (PacketContext)packetContext);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                return;
            }
            HardcoreQuestingCore.LOGGER.error("Invalid Packet ID: " + id);
        });
    }

    private static void registerMessage(Class<? extends IMessageHandler> handlerClass, Class<? extends IMessage> messageClass, int id, Dist envType) {
        PACKET_HANDLERS.put(messageClass, (Tuple<Class<? extends IMessageHandler>, Integer>)new Tuple(handlerClass, (Object)id));
    }

    public static void sendToPlayer(IMessage message, ServerPlayerEntity player) {
        if (player == null) {
            return;
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        Tuple<Class<? extends IMessageHandler>, Integer> pair = PACKET_HANDLERS.get(message.getClass());
        buf.writeInt(((Integer)pair.func_76340_b()).intValue());
        message.toBytes(buf);
        HardcoreQuestingCore.platform.getNetworkManager().sendToPlayer(player, S2C, buf);
    }

    public static void sendToAllPlayers(IMessage message) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        Tuple<Class<? extends IMessageHandler>, Integer> pair = PACKET_HANDLERS.get(message.getClass());
        buf.writeInt(((Integer)pair.func_76340_b()).intValue());
        message.toBytes(buf);
        for (ServerPlayerEntity entity : HardcoreQuestingCore.getServer().func_184103_al().func_181057_v()) {
            HardcoreQuestingCore.platform.getNetworkManager().sendToPlayer(entity, S2C, new PacketBuffer(buf.copy()));
        }
    }

    public static void sendToServer(IMessage message) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        Tuple<Class<? extends IMessageHandler>, Integer> pair = PACKET_HANDLERS.get(message.getClass());
        buf.writeInt(((Integer)pair.func_76340_b()).intValue());
        message.toBytes(buf);
        HardcoreQuestingCore.platform.getNetworkManager().sendToServer(C2S, buf);
    }

    public static void sendToPlayersAround(IMessage message, TileEntity te, double radius) {
        BlockPos pos = te.func_174877_v();
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        Tuple<Class<? extends IMessageHandler>, Integer> pair = PACKET_HANDLERS.get(message.getClass());
        buf.writeInt(((Integer)pair.func_76340_b()).intValue());
        message.toBytes(buf);
        IPacket<?> packet = HardcoreQuestingCore.platform.getNetworkManager().createToPlayerPacket(S2C, buf);
        HardcoreQuestingCore.getServer().func_184103_al().func_148543_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), radius, te.func_145831_w().func_234923_W_(), packet);
    }

    public static <T extends TileEntity> void sendBlockUpdate(T block, PlayerEntity player, int type) {
        StringWriter data = new StringWriter();
        boolean onServer = !block.func_145831_w().field_72995_K;
        try {
            JsonWriter writer = new JsonWriter((Writer)data);
            writer.beginObject();
            ((IBlockSync)block).writeData(player, onServer, type, writer);
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            return;
        }
        if (!onServer) {
            NetworkManager.sendToServer(new BlockSyncMessageClient(block, type, data.toString()));
        } else {
            BlockSyncMessage message = new BlockSyncMessage(block, type, data.toString());
            if (player instanceof ServerPlayerEntity) {
                NetworkManager.sendToPlayer(message, (ServerPlayerEntity)player);
            } else {
                NetworkManager.sendToPlayersAround(message, block, 128.0);
            }
        }
    }

    public static void sendSyncPacket(TileEntity tile) {
        if (tile instanceof ISyncableTile && !tile.func_145831_w().field_72995_K) {
            NetworkManager.sendToPlayersAround(new SyncableTileMessage(tile), tile, 128.0);
        }
    }
}

