/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.GuiReward;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.GeneralUpdateMessage;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.QuestTask;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum GeneralUsage {
    BOOK_OPEN{

        @Override
        public void receiveData(PlayerEntity player, CompoundNBT nbt) {
            GuiQuestBook.displayGui(player, nbt.func_74767_n("OP"));
        }
    }
    ,
    BOOK_SELECT_TASK{

        @Override
        public void receiveData(PlayerEntity player, CompoundNBT nbt) {
            QuestingData data = QuestingDataManager.getInstance().getQuestingData(player);
            data.selectedQuestId = nbt.func_186857_a("QuestId");
            data.selectedTask = nbt.func_74762_e("TaskId");
        }
    }
    ,
    BAG_OPENED{

        @Override
        public void receiveData(PlayerEntity player, CompoundNBT nbt) {
            UUID groupId = nbt.func_186857_a("GroupId");
            int bag = nbt.func_74762_e("Bag");
            int[] limits = nbt.func_74759_k("Limits");
            GuiReward.open(player, groupId, bag, limits);
        }
    };


    public static void sendOpenBook(PlayerEntity player, boolean op) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("OP", op);
        BOOK_OPEN.sendMessageToPlayer(nbt, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendBookSelectTaskUpdate(QuestTask task) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_186854_a("QuestId", task.getParent().getQuestId());
        nbt.func_74768_a("TaskId", task.getId());
        BOOK_SELECT_TASK.sendMessageToServer(nbt);
    }

    public static void sendOpenBagUpdate(PlayerEntity player, UUID groupId, int bag, int[] limits) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_186854_a("GroupId", groupId);
        nbt.func_74768_a("Bag", bag);
        nbt.func_74783_a("Limits", limits);
        BAG_OPENED.sendMessageToPlayer(nbt, player);
    }

    public abstract void receiveData(PlayerEntity var1, CompoundNBT var2);

    @OnlyIn(value=Dist.CLIENT)
    public void sendMessageToServer(CompoundNBT data) {
        NetworkManager.sendToServer(new GeneralUpdateMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, data, this.ordinal()));
    }

    public void sendMessageToPlayer(CompoundNBT data, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkManager.sendToPlayer(new GeneralUpdateMessage(player, data, this.ordinal()), (ServerPlayerEntity)player);
        }
    }
}

