/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.items;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.items.ModCreativeTabs;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.network.GeneralUsage;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class QuestBookItem
extends Item {
    private static final String NBT_PLAYER = "UseAsPlayer";
    private boolean enabled;

    public QuestBookItem(boolean enabled) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ModCreativeTabs.HQMTab));
        this.enabled = enabled;
    }

    public static ItemStack getOPBook(PlayerEntity player) {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.enabledBook.get());
        CompoundNBT nbt = stack.func_190925_c("hqm");
        nbt.func_74778_a(NBT_PLAYER, player.func_110124_au().toString());
        stack.func_77983_a("hqm", (INBT)nbt);
        return stack;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @NotNull Hand hand) {
        if (world.field_72995_K && Quest.isEditing && !HQMUtil.isGameSingleplayer()) {
            Quest.setEditMode(false);
        }
        if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
            ItemStack stack = player.func_184586_b(hand);
            QuestingDataManager questingData = QuestingDataManager.getInstance();
            if (!questingData.isQuestActive()) {
                player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.noQuestYet", new Object[0]), Util.field_240973_b_);
            } else if (stack.func_77973_b() == ModItems.enabledBook.get()) {
                CompoundNBT compound = stack.func_179543_a("hqm");
                if (compound != null && compound.func_74764_b(NBT_PLAYER)) {
                    UUID uuid;
                    String uuidS = compound.func_74779_i(NBT_PLAYER);
                    try {
                        uuid = UUID.fromString(uuidS);
                    }
                    catch (IllegalArgumentException e) {
                        compound.func_82580_o(NBT_PLAYER);
                        return ActionResult.func_226251_d_((Object)stack);
                    }
                    if (questingData.hasData(uuid)) {
                        if (HardcoreQuestingCore.getServer().func_211833_a(player.func_146103_bH()) >= 4) {
                            PlayerEntity subject = QuestingData.getPlayer(uuid);
                            if (subject instanceof ServerPlayerEntity) {
                                EventTrigger.instance().onBookOpening(new EventTrigger.BookOpeningEvent(player.func_110124_au(), true, false));
                                PlayerEntry entry = questingData.getQuestingData(subject).getTeam().getEntry(subject.func_110124_au());
                                if (entry != null) {
                                    entry.setBookOpen(true);
                                    GeneralUsage.sendOpenBook(player, true);
                                } else {
                                    player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.bookNoEntry", new Object[0]), Util.field_240973_b_);
                                }
                            }
                        } else {
                            player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.bookNoPermission", new Object[0]), Util.field_240973_b_);
                        }
                    } else {
                        player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.bookNoData", new Object[0]), Util.field_240973_b_);
                    }
                }
            } else {
                EventTrigger.instance().onBookOpening(new EventTrigger.BookOpeningEvent(player.func_110124_au(), false, true));
                PlayerEntry entry = questingData.getQuestingData(player).getTeam().getEntry(player.func_110124_au());
                if (entry != null) {
                    entry.setBookOpen(true);
                    GeneralUsage.sendOpenBook(player, false);
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("hqm.message.bookNoPlayer"), Util.field_240973_b_);
                }
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        if (stack.func_77973_b() == ModItems.enabledBook.get()) {
            CompoundNBT compound = stack.func_179543_a("hqm");
            if (compound != null && compound.func_74764_b(NBT_PLAYER)) {
                PlayerEntity useAsPlayer = QuestingData.getPlayer(compound.func_74779_i(NBT_PLAYER));
                tooltip.add((ITextComponent)Translator.translatable("item.hqm:quest_book_1.useAs", useAsPlayer == null ? "INVALID" : useAsPlayer.func_195047_I_()));
            } else {
                tooltip.add((ITextComponent)Translator.translatable("item.hqm:quest_book_1.invalid", new Object[0]).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)(GuiColor.RED.getHexColor() & 0xFFFFFF)))));
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77973_b() == ModItems.enabledBook.get();
    }
}

