/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.items;

import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.death.DeathType;
import hardcorequesting.common.forge.items.ModCreativeTabs;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemHeart
extends Item {
    private int value;

    public ItemHeart(int value) {
        super(new Item.Properties().func_200917_a(64).func_200916_a(ModCreativeTabs.HQMTab));
        this.value = value;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            QuestingDataManager questingDataManager = QuestingDataManager.getInstance();
            ItemStack stack = player.func_184586_b(hand);
            if (this.value == 3) {
                if (!questingDataManager.isHardcoreActive()) {
                    player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.noHardcoreYet", new Object[0]), Util.field_240973_b_);
                } else if (questingDataManager.getQuestingData(player).getRawLives() < HQMConfig.getInstance().Hardcore.MAX_LIVES) {
                    questingDataManager.getQuestingData(player).addLives(player, 1);
                    player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.addOne", new Object[0]), Util.field_240973_b_);
                    int lives = questingDataManager.getQuestingData(player).getLives();
                    player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.haveRemaining", lives), Util.field_240973_b_);
                    SoundHandler.play(Sounds.LIFE, player);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                } else {
                    player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.haveMaxLives", new Object[0]), Util.field_240973_b_);
                }
            }
            if (this.value == 4) {
                if (!questingDataManager.isHardcoreActive()) {
                    player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.noHardcoreYet", new Object[0]), Util.field_240973_b_);
                } else {
                    SoundHandler.play(Sounds.ROTTEN, player);
                    player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.eatRottenHearth", new Object[0]), Util.field_240973_b_);
                    questingDataManager.getQuestingData(player).removeLifeAndSendMessage(player);
                    DeathType.HQM.onDeath(player);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190917_f(1);
                    }
                }
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity entityPlayer = (PlayerEntity)entity;
            if (this.value == 3 && HQMConfig.getInstance().Hardcore.HEART_ROT_ENABLE) {
                CompoundNBT tagCompound = stack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new CompoundNBT();
                    stack.func_77982_d(tagCompound);
                }
                if (!tagCompound.func_74764_b("RotTime")) {
                    int rot = HQMConfig.getInstance().Hardcore.HEART_ROT_TIME * 20;
                    tagCompound.func_74768_a("MaxRot", rot);
                    tagCompound.func_74768_a("RotTime", rot);
                } else {
                    int newRot = tagCompound.func_74762_e("RotTime");
                    if (newRot <= 0) {
                        stack = new ItemStack((IItemProvider)ModItems.rottenHeart.get());
                        entityPlayer.func_145747_a((ITextComponent)Translator.translatable("hqm.message.hearthDecay", new Object[0]), Util.field_240973_b_);
                    } else {
                        tagCompound.func_74768_a("RotTime", newRot - 1);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        super.func_77624_a(stack, world, tooltip, context);
        if (this.value == 3) {
            tooltip.add((ITextComponent)Translator.translatable("item.hqm:hearts_heart.tooltip", new Object[0]));
            if (HQMConfig.getInstance().Hardcore.HEART_ROT_ENABLE) {
                CompoundNBT tagCompound = stack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new CompoundNBT();
                    stack.func_77982_d(tagCompound);
                }
                if (tagCompound.func_74764_b("RotTime")) {
                    int rot = tagCompound.func_74762_e("RotTime");
                    int maxRot = tagCompound.func_74762_e("MaxRot");
                    float percentage = rot * 100 / maxRot;
                    tooltip.add((ITextComponent)Translator.translatable("item.hqm:hearts_heart.freshness", Float.valueOf(percentage)));
                }
            }
        }
        if (this.value == 4) {
            tooltip.add((ITextComponent)Translator.translatable("item.hqm:hearts_rottenheart.tooltip", new Object[0]));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.value == 3 || this.value == 4;
    }
}

