/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import net.minecraft.util.JSONUtils;

public class ReputationAdapter {
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private static final Adapter<ReputationMarker> REPUTATION_MARKER_ADAPTER = new Adapter<ReputationMarker>(){
        private static final String NAME = "name";
        private static final String VALUE = "value";

        @Override
        public JsonElement serialize(ReputationMarker src) {
            return 1.object().add(NAME, src.getName()).add(VALUE, src.getValue()).build();
        }

        @Override
        public ReputationMarker deserialize(JsonElement json) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new ReputationMarker(JSONUtils.func_151219_a((JsonObject)object, (String)NAME, (String)"Unnamed"), JSONUtils.func_151208_a((JsonObject)object, (String)VALUE, (int)0), false);
        }
    };
    public static final Adapter<Reputation> REPUTATION_ADAPTER = new Adapter<Reputation>(){
        private static final String ID = "id";
        private static final String NAME = "name";
        private static final String NEUTRAL = "neutral";
        private static final String MARKERS = "markers";

        @Override
        public JsonElement serialize(Reputation src) {
            return 2.object().add(ID, src.getId()).add(NAME, src.getName()).add(NEUTRAL, src.getNeutralName()).add(MARKERS, (JsonElement)2.array().use(builder -> {
                for (int i = 0; i < src.getMarkerCount(); ++i) {
                    builder.add(REPUTATION_MARKER_ADAPTER.serialize(src.getMarker(i)));
                }
            }).build()).build();
        }

        @Override
        public Reputation deserialize(JsonElement json) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            Reputation reputation = new Reputation(JSONUtils.func_151219_a((JsonObject)object, (String)ID, null), JSONUtils.func_151219_a((JsonObject)object, (String)NAME, (String)"Unnamed"), JSONUtils.func_151219_a((JsonObject)object, (String)NEUTRAL, (String)"Neutral"));
            for (JsonElement element : JSONUtils.func_151213_a((JsonObject)object, (String)MARKERS, (JsonArray)EMPTY_ARRAY)) {
                reputation.add((ReputationMarker)REPUTATION_MARKER_ADAPTER.deserialize(element));
            }
            return reputation;
        }
    };
}

