/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hardcorequesting.common.forge.bag.GroupData;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.TeamAdapter;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.team.Team;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Util;

public class QuestingAdapter {
    public static final Adapter<QuestingData> QUESTING_DATA_ADAPTER = new Adapter<QuestingData>(){
        public static final String KEY_TEAM = "team";
        public static final String KEY_LIVES = "lives";
        public static final String KEY_UUID = "uuid";
        public static final String KEY_NAME = "name";
        public static final String KEY_GROUP_DATA = "groupData";
        public static final String KEY_SELECTED_QUEST = "selectedQuest";
        public static final String KEY_PLAYER_LORE = "playedLore";
        public static final String KEY_RECEIVED_BOOK = "receivedBook";

        @Override
        public JsonElement serialize(QuestingData src) {
            return 1.object().add(KEY_UUID, src.getPlayerId().toString()).add(KEY_NAME, src.getName()).add(KEY_LIVES, src.getRawLives()).add(KEY_TEAM, (JsonElement)(src.getTeam().isSingle() ? TeamAdapter.TEAM_ADAPTER.serialize(src.getTeam()) : new JsonPrimitive(src.getTeam().getId().toString()))).add(KEY_SELECTED_QUEST, src.selectedQuestId != null ? src.selectedQuestId.toString() : null).add(KEY_PLAYER_LORE, src.playedLore).add(KEY_RECEIVED_BOOK, src.receivedBook).add(KEY_GROUP_DATA, (JsonElement)1.object().use(builder -> {
                for (Map.Entry<UUID, GroupData> entry : src.getGroupData().entrySet()) {
                    if (entry.getKey() == null) continue;
                    builder.add(entry.getKey().toString(), entry.getValue().retrieved);
                }
            }).build()).build();
        }

        @Override
        public QuestingData deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            String uuid = object.get(KEY_UUID).getAsString();
            int lives = JSONUtils.func_151208_a((JsonObject)object, (String)KEY_LIVES, (int)0);
            UUID teamId = object.get(KEY_TEAM).isJsonPrimitive() && object.get(KEY_TEAM).getAsJsonPrimitive().isString() ? UUID.fromString(object.get(KEY_TEAM).getAsString()) : Util.field_240973_b_;
            Team team = !teamId.equals(Util.field_240973_b_) ? null : (Team)TeamAdapter.TEAM_ADAPTER.fromJsonTree(object.get(KEY_TEAM));
            String selectedQuest = JSONUtils.func_151219_a((JsonObject)object, (String)KEY_SELECTED_QUEST, null);
            boolean playerLore = JSONUtils.func_151209_a((JsonObject)object, (String)KEY_PLAYER_LORE, (boolean)false);
            boolean receivedBook = JSONUtils.func_151209_a((JsonObject)object, (String)KEY_RECEIVED_BOOK, (boolean)false);
            HashMap<UUID, GroupData> data = new HashMap<UUID, GroupData>();
            for (Map.Entry entry : JSONUtils.func_151218_a((JsonObject)object, (String)KEY_GROUP_DATA, (JsonObject)new JsonObject()).entrySet()) {
                data.put(UUID.fromString((String)entry.getKey()), new GroupData(((JsonElement)entry.getValue()).getAsInt()));
            }
            QuestingData questingData = new QuestingData(QuestingDataManager.getInstance(), UUID.fromString(uuid), lives, data);
            questingData.playedLore = playerLore;
            questingData.receivedBook = receivedBook;
            if (selectedQuest != null) {
                questingData.selectedQuestId = UUID.fromString(selectedQuest);
            }
            if (teamId.equals(Util.field_240973_b_)) {
                questingData.setTeam(team);
            }
            questingData.setName(JSONUtils.func_151219_a((JsonObject)object, (String)KEY_NAME, null));
            return questingData;
        }
    };
}

