/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.MinecraftAdapter;
import hardcorequesting.common.forge.io.adapter.QuestAdapter;
import hardcorequesting.common.forge.platform.FluidStack;
import hardcorequesting.common.forge.quests.ItemPrecision;
import hardcorequesting.common.forge.quests.data.AdvancementTaskData;
import hardcorequesting.common.forge.quests.data.CompleteQuestTaskData;
import hardcorequesting.common.forge.quests.data.DeathTaskData;
import hardcorequesting.common.forge.quests.data.ItemsTaskData;
import hardcorequesting.common.forge.quests.data.LocationTaskData;
import hardcorequesting.common.forge.quests.data.MobTaskData;
import hardcorequesting.common.forge.quests.data.ReputationKillTaskData;
import hardcorequesting.common.forge.quests.data.TameTaskData;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.task.CompleteQuestTask;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.icon.GetAdvancementTask;
import hardcorequesting.common.forge.quests.task.icon.KillMobsTask;
import hardcorequesting.common.forge.quests.task.icon.TameMobsTask;
import hardcorequesting.common.forge.quests.task.icon.VisitLocationTask;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class QuestTaskAdapter {
    public static final Adapter<TaskData> QUEST_DATA_TASK_ADAPTER = new Adapter<TaskData>(){
        private static final String TYPE = "type";

        @Override
        public JsonElement serialize(TaskData src) {
            Adapter.JsonObjectBuilder builder = 1.object().add(TYPE, String.valueOf((Object)src.getDataType()));
            src.write(builder);
            return builder.build();
        }

        @Override
        public TaskData deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            return QuestDataType.valueOf(JSONUtils.func_151200_h((JsonObject)object, (String)TYPE)).construct(object);
        }
    };
    public static final TypeAdapter<ItemRequirementTask.Part> ITEM_REQUIREMENT_ADAPTER = new TypeAdapter<ItemRequirementTask.Part>(){
        private static final String ITEM = "item";
        private static final String FLUID = "fluid";
        private static final String REQUIRED = "required";
        private static final String PRECISION = "precision";

        public void write(JsonWriter out, ItemRequirementTask.Part value) throws IOException {
            ItemStack stack = value.getStack();
            FluidStack fluid = value.fluid;
            int required = value.required;
            ItemPrecision precision = value.getPrecision();
            out.beginObject();
            if (value.hasItem && !stack.func_190926_b()) {
                MinecraftAdapter.ITEM_STACK.write(out.name(ITEM), stack);
            } else if (fluid != null) {
                MinecraftAdapter.FLUID.write(out.name(FLUID), fluid);
            } else {
                out.nullValue();
                out.endObject();
                return;
            }
            if (required != 1) {
                out.name(REQUIRED).value((long)required);
            }
            if (precision != ItemPrecision.PRECISE) {
                out.name(PRECISION).value(ItemPrecision.getUniqueID(precision));
            }
            out.endObject();
        }

        public ItemRequirementTask.Part read(JsonReader in) throws IOException {
            ItemRequirementTask.Part result;
            in.beginObject();
            ItemStack itemStack = ItemStack.field_190927_a;
            FluidStack fluidVolume = null;
            int required = 1;
            ItemPrecision precision = ItemPrecision.PRECISE;
            while (in.hasNext()) {
                ItemPrecision itemPrecision;
                String next = in.nextName();
                if (next.equalsIgnoreCase(ITEM)) {
                    itemStack = MinecraftAdapter.ITEM_STACK.read(in);
                    continue;
                }
                if (next.equalsIgnoreCase(FLUID)) {
                    fluidVolume = MinecraftAdapter.FLUID.read(in);
                    continue;
                }
                if (next.equalsIgnoreCase(REQUIRED)) {
                    required = Math.max(in.nextInt(), required);
                    continue;
                }
                if (!next.equalsIgnoreCase(PRECISION) || (itemPrecision = ItemPrecision.getPrecisionType(in.nextString())) == null) continue;
                precision = itemPrecision;
            }
            in.endObject();
            if (!itemStack.func_190926_b()) {
                result = new ItemRequirementTask.Part(itemStack, required);
            } else if (fluidVolume != null) {
                result = new ItemRequirementTask.Part(fluidVolume, required);
            } else {
                return null;
            }
            result.setPrecision(precision);
            return result;
        }
    };
    public static final Adapter<VisitLocationTask.Part> LOCATION_ADAPTER = new Adapter<VisitLocationTask.Part>(){
        private static final String X = "x";
        private static final String Y = "y";
        private static final String Z = "z";
        private static final String DIM = "dim";
        private static final String ICON = "icon";
        private static final String RADIUS = "radius";
        private static final String VISIBLE = "visible";
        private static final String NAME = "name";

        @Override
        public JsonElement serialize(VisitLocationTask.Part src) {
            return 3.object().add(NAME, src.getName()).add(X, src.getPosition().func_177958_n()).add(Y, src.getPosition().func_177956_o()).add(Z, src.getPosition().func_177952_p()).add(DIM, src.getDimension()).add(RADIUS, src.getRadius()).add(VISIBLE, src.getVisibility().name()).use(builder -> {
                ItemStack stack = src.getIconStack();
                if (stack != null) {
                    builder.add(ICON, MinecraftAdapter.ITEM_STACK.serialize(stack));
                } else {
                    builder.add(ICON, MinecraftAdapter.ITEM_STACK.serialize(ItemStack.field_190927_a));
                }
            }).build();
        }

        @Override
        public VisitLocationTask.Part deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            VisitLocationTask.Part result = new VisitLocationTask.Part();
            result.setName(JSONUtils.func_151200_h((JsonObject)object, (String)NAME));
            result.setPosition(new BlockPos(JSONUtils.func_151203_m((JsonObject)object, (String)X), JSONUtils.func_151203_m((JsonObject)object, (String)Y), JSONUtils.func_151203_m((JsonObject)object, (String)Z)));
            result.setDimension(JSONUtils.func_151200_h((JsonObject)object, (String)DIM));
            result.setRadius(JSONUtils.func_151203_m((JsonObject)object, (String)RADIUS));
            result.setVisibility(VisitLocationTask.Visibility.valueOf(JSONUtils.func_151219_a((JsonObject)object, (String)VISIBLE, (String)result.getVisibility().name())));
            if (object.has(ICON)) {
                result.setIconStack(MinecraftAdapter.ITEM_STACK.deserialize(object.get(ICON)));
            }
            return result;
        }
    };
    public static final Adapter<ReputationTask.Part> REPUTATION_TASK_ADAPTER = new Adapter<ReputationTask.Part>(){
        private static final String REPUTATION = "reputation";
        private static final String LOWER = "lower";
        private static final String UPPER = "upper";
        private static final String INVERTED = "inverted";

        @Override
        public JsonElement serialize(ReputationTask.Part src) {
            Adapter.JsonObjectBuilder builder = 4.object().add(REPUTATION, src.getReputation().getId()).add(INVERTED, src.isInverted());
            if (src.getLower() != null) {
                builder.add(LOWER, src.getLower().getId());
            }
            if (src.getUpper() != null) {
                builder.add(UPPER, src.getUpper().getId());
            }
            return builder.build();
        }

        @Override
        public ReputationTask.Part deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            Reputation reputation = ReputationManager.getInstance().getReputation(JSONUtils.func_151219_a((JsonObject)object, (String)REPUTATION, null));
            ReputationMarker lower = null;
            ReputationMarker upper = null;
            if (object.has(LOWER)) {
                lower = reputation.getMarker(JSONUtils.func_151203_m((JsonObject)object, (String)LOWER));
            }
            if (object.has(UPPER)) {
                upper = reputation.getMarker(JSONUtils.func_151203_m((JsonObject)object, (String)UPPER));
            }
            if (reputation == null) {
                return null;
            }
            return new ReputationTask.Part(reputation, lower, upper, JSONUtils.func_151209_a((JsonObject)object, (String)INVERTED, (boolean)false));
        }
    };
    public static final TypeAdapter<TameMobsTask.Part> TAME_ADAPTER = new TypeAdapter<TameMobsTask.Part>(){
        private static final String TAMES = "tames";
        private static final String EXACT = "exact";
        private static final String TAME = "tame";
        private static final String ICON = "icon";
        private static final String NAME = "name";

        public void write(JsonWriter out, TameMobsTask.Part value) throws IOException {
            out.beginObject();
            out.name(NAME).value(value.getName());
            ItemStack stack = value.getIconStack();
            if (stack != null) {
                MinecraftAdapter.ITEM_STACK.write(out.name(ICON), stack);
            }
            out.name(TAME).value(value.getTame());
            out.name(TAMES).value((long)value.getCount());
            out.endObject();
        }

        public TameMobsTask.Part read(JsonReader in) throws IOException {
            in.beginObject();
            TameMobsTask.Part result = new TameMobsTask.Part();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equalsIgnoreCase(NAME)) {
                    result.setName(in.nextString());
                    continue;
                }
                if (name.equalsIgnoreCase(ICON)) {
                    ItemStack icon = MinecraftAdapter.ITEM_STACK.read(in);
                    if (icon.func_190926_b()) continue;
                    result.setIconStack(icon);
                    continue;
                }
                if (name.equalsIgnoreCase(TAME)) {
                    result.setTame(in.nextString());
                    continue;
                }
                if (!name.equalsIgnoreCase(TAMES)) continue;
                result.setCount(in.nextInt());
            }
            in.endObject();
            return result;
        }
    };
    public static final TypeAdapter<GetAdvancementTask.Part> ADVANCEMENT_TASK_ADAPTER = new TypeAdapter<GetAdvancementTask.Part>(){
        private final String ICON = "icon";
        private final String VISIBLE = "visible";
        private final String NAME = "name";
        private final String ADV_NAME = "adv_name";

        public void write(JsonWriter out, GetAdvancementTask.Part value) throws IOException {
            out.beginObject();
            out.name("name").value(value.getName());
            ItemStack stack = value.getIconStack();
            if (stack != null) {
                MinecraftAdapter.ITEM_STACK.write(out.name("icon"), stack);
            }
            if (value.getAdvancement() != null) {
                out.name("adv_name").value(value.getAdvancement());
            }
            if (value.getVisible() != GetAdvancementTask.Visibility.FULL) {
                out.name("visible").value(value.getVisible().name());
            }
            out.endObject();
        }

        public GetAdvancementTask.Part read(JsonReader in) throws IOException {
            in.beginObject();
            GetAdvancementTask.Part result = new GetAdvancementTask.Part();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equalsIgnoreCase("name")) {
                    result.setName(in.nextString());
                    continue;
                }
                if (name.equalsIgnoreCase("icon")) {
                    result.setIconStack(MinecraftAdapter.ITEM_STACK.read(in));
                    continue;
                }
                if (name.equalsIgnoreCase("adv_name")) {
                    result.setAdvancement(in.nextString());
                    continue;
                }
                if (!name.equalsIgnoreCase("visible")) continue;
                result.setVisible(GetAdvancementTask.Visibility.valueOf(in.nextString()));
            }
            in.endObject();
            return result;
        }
    };
    public static final TypeAdapter<CompleteQuestTask.Part> QUEST_COMPLETED_ADAPTER = new TypeAdapter<CompleteQuestTask.Part>(){
        private final String VISIBLE = "visible";
        private final String QUEST_UUID = "quest_uuid";

        public void write(JsonWriter out, CompleteQuestTask.Part value) throws IOException {
            out.beginObject();
            if (value.getQuest() != null) {
                out.name("quest_uuid").value(value.getQuestId().toString());
            }
            out.endObject();
        }

        public CompleteQuestTask.Part read(JsonReader in) throws IOException {
            in.beginObject();
            CompleteQuestTask.Part result = new CompleteQuestTask.Part();
            while (in.hasNext()) {
                String name = in.nextName();
                if (!name.equalsIgnoreCase("quest_uuid")) continue;
                result.setQuest(UUID.fromString(in.nextString()));
            }
            in.endObject();
            return result;
        }
    };
    public static final Adapter<KillMobsTask.Part> MOB_ADAPTER = new Adapter<KillMobsTask.Part>(){
        private static final String KILLS = "kills";
        private static final String MOB = "mob";
        private static final String ICON = "icon";
        private static final String NAME = "name";

        @Override
        public JsonElement serialize(KillMobsTask.Part src) {
            return 8.object().add(NAME, src.getName()).use(builder -> {
                ItemStack stack = src.getIconStack();
                if (stack != null) {
                    builder.add(ICON, MinecraftAdapter.ITEM_STACK.toJsonTree(stack));
                }
            }).add(MOB, src.getMob().toString()).add(KILLS, src.getCount()).build();
        }

        @Override
        public KillMobsTask.Part deserialize(JsonElement json) {
            ItemStack icon;
            JsonObject object = json.getAsJsonObject();
            KillMobsTask.Part result = new KillMobsTask.Part();
            result.setName(JSONUtils.func_151219_a((JsonObject)object, (String)NAME, (String)result.getName()));
            result.setMob(new ResourceLocation(JSONUtils.func_151219_a((JsonObject)object, (String)MOB, (String)result.getMob().toString())));
            result.setCount(JSONUtils.func_151208_a((JsonObject)object, (String)KILLS, (int)result.getCount()));
            if (object.has(ICON) && !(icon = MinecraftAdapter.ITEM_STACK.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)object, (String)ICON))).func_190926_b()) {
                result.setIconStack(icon);
            }
            return result;
        }
    };
    public static Map<ReputationTask<?>, List<ReputationSettingConstructor>> taskReputationListMap = new HashMap();
    protected static final Adapter<QuestTask<?>> TASK_ADAPTER = new Adapter<QuestTask<?>>(){
        private static final String TYPE = "type";
        private static final String DESCRIPTION = "description";
        private static final String LONG_DESCRIPTION = "longDescription";

        @Override
        public JsonElement serialize(QuestTask<?> src) {
            TaskType type = TaskType.getType(src.getClass());
            Adapter.JsonObjectBuilder builder = 9.object().add(TYPE, type.name());
            if (!src.getDescription().equals(type.getName())) {
                builder.add(DESCRIPTION, src.getDescription());
            }
            if (!src.getLongDescription().equals(type.getDescription())) {
                builder.add(LONG_DESCRIPTION, src.getLongDescription());
            }
            src.write(builder);
            return builder.build();
        }

        @Override
        public QuestTask<?> deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            TaskType type = TaskType.valueOf(JSONUtils.func_151200_h((JsonObject)object, (String)TYPE));
            QuestTask<?> TASK = type.addTask(QuestAdapter.QUEST);
            if (object.has(DESCRIPTION)) {
                TASK.setDescription(JSONUtils.func_151200_h((JsonObject)object, (String)DESCRIPTION));
            }
            if (object.has(LONG_DESCRIPTION)) {
                TASK.setLongDescription(JSONUtils.func_151200_h((JsonObject)object, (String)LONG_DESCRIPTION));
            }
            TASK.read(object);
            return TASK;
        }
    };

    public static class ReputationSettingConstructor {
        private static final String REPUTATION = "reputation";
        private static final String LOWER = "lower";
        private static final String UPPER = "upper";
        private static final String INVERTED = "inverted";
        String reputation;
        boolean inverted;
        private int upper;
        private int lower;

        private ReputationSettingConstructor(String reputation, int lower, int upper, boolean inverted) {
            this.reputation = reputation;
            this.lower = lower;
            this.upper = upper;
            this.inverted = inverted;
        }

        public static ReputationSettingConstructor read(JsonElement in) {
            JsonObject object = in.getAsJsonObject();
            String reputation = JSONUtils.func_151219_a((JsonObject)object, (String)REPUTATION, null);
            if (reputation == null) {
                return null;
            }
            return new ReputationSettingConstructor(reputation, JSONUtils.func_151208_a((JsonObject)object, (String)LOWER, (int)Integer.MIN_VALUE), JSONUtils.func_151208_a((JsonObject)object, (String)UPPER, (int)Integer.MIN_VALUE), JSONUtils.func_151209_a((JsonObject)object, (String)INVERTED, (boolean)false));
        }

        public ReputationTask.Part constructReputationSetting() {
            Reputation reputation = ReputationManager.getInstance().getReputations().get(this.reputation);
            if (reputation != null) {
                ReputationMarker lower = null;
                ReputationMarker upper = null;
                if (this.lower >= 0 && this.lower < reputation.getMarkerCount()) {
                    lower = reputation.getMarker(this.lower);
                }
                if (this.upper >= 0 && this.upper < reputation.getMarkerCount()) {
                    upper = reputation.getMarker(this.upper);
                }
                return new ReputationTask.Part(reputation, lower, upper, this.inverted);
            }
            return null;
        }
    }

    public static enum QuestDataType {
        GENERIC(TaskData::construct),
        DEATH(DeathTaskData::construct),
        ITEMS(ItemsTaskData::construct),
        LOCATION(LocationTaskData::construct),
        MOB(MobTaskData::construct),
        REPUTATION_KILL(ReputationKillTaskData::construct),
        TAME(TameTaskData::construct),
        ADVANCEMENT(AdvancementTaskData::construct),
        COMPLETED(CompleteQuestTaskData::construct);

        private Function<JsonObject, TaskData> func;

        private QuestDataType(Function<JsonObject, TaskData> func) {
            this.func = func;
        }

        public TaskData construct(JsonObject in) {
            return this.func.apply(in);
        }
    }
}

