/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.data.TaskData;
import java.io.IOException;

public class QuestDataAdapter {
    public static final TypeAdapter<QuestData> QUEST_DATA_ADAPTER = new TypeAdapter<QuestData>(){
        public static final String PLAYERS = "players";
        public static final String REWARDS = "rewards";
        public static final String COMPLETED = "completed";
        public static final String CLAIMED = "claimed";
        public static final String TASKS = "tasks";
        public static final String TASKS_SIZE = "tasksSize";
        public static final String AVAILABLE = "available";
        public static final String TIME = "time";

        public void write(JsonWriter out, QuestData value) throws IOException {
            out.beginObject();
            out.name(PLAYERS).value((long)value.reward.length);
            out.name(REWARDS).beginArray();
            for (boolean bool : value.reward) {
                out.value(bool);
            }
            out.endArray();
            out.name(COMPLETED).value(value.completed);
            out.name(CLAIMED).value(value.claimed);
            out.name(AVAILABLE).value(value.available);
            out.name(TIME).value(value.time);
            out.name(TASKS_SIZE).value((long)value.tasks.length);
            out.name(TASKS).beginArray();
            for (TaskData task : value.tasks) {
                if (task == null) continue;
                QuestTaskAdapter.QUEST_DATA_TASK_ADAPTER.write(out, task);
            }
            out.endArray();
            out.endObject();
        }

        public QuestData read(JsonReader in) throws IOException {
            QuestData data = new QuestData(1);
            in.beginObject();
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "players": {
                        data = new QuestData(in.nextInt());
                        break;
                    }
                    case "rewards": {
                        in.beginArray();
                        int i = 0;
                        while (in.hasNext() && i < data.reward.length) {
                            data.reward[i++] = in.nextBoolean();
                        }
                        in.endArray();
                        break;
                    }
                    case "completed": {
                        data.completed = in.nextBoolean();
                        break;
                    }
                    case "claimed": {
                        data.claimed = in.nextBoolean();
                        break;
                    }
                    case "available": {
                        data.available = in.nextBoolean();
                        break;
                    }
                    case "time": {
                        data.time = in.nextLong();
                        break;
                    }
                    case "tasksSize": {
                        data.tasks = new TaskData[in.nextInt()];
                        break;
                    }
                    case "tasks": {
                        in.beginArray();
                        int i = 0;
                        while (in.hasNext() && i < data.tasks.length) {
                            data.tasks[i++] = QuestTaskAdapter.QUEST_DATA_TASK_ADAPTER.read(in);
                        }
                        in.endArray();
                        break;
                    }
                }
            }
            in.endObject();
            return data;
        }
    };
}

