/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.MinecraftAdapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.QuestSetsManager;
import hardcorequesting.common.forge.quests.RepeatInfo;
import hardcorequesting.common.forge.quests.RepeatType;
import hardcorequesting.common.forge.quests.TriggerType;
import hardcorequesting.common.forge.quests.reward.ReputationReward;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationBar;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;

public class QuestAdapter {
    private static final Adapter<RepeatInfo> REPEAT_INFO_ADAPTER = new Adapter<RepeatInfo>(){
        private static final String TYPE = "type";
        private static final String HOURS = "hours";
        private static final String DAYS = "days";

        @Override
        public JsonElement serialize(RepeatInfo src) {
            Adapter.JsonObjectBuilder object = 1.object().add(TYPE, src.getType().name());
            if (src.getType().isUseTime()) {
                object.add(DAYS, src.getDays());
                object.add(HOURS, src.getHours());
            }
            return object.build();
        }

        @Override
        public RepeatInfo deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            return new RepeatInfo(RepeatType.valueOf(JSONUtils.func_151200_h((JsonObject)object, (String)TYPE)), JSONUtils.func_151208_a((JsonObject)object, (String)DAYS, (int)0), JSONUtils.func_151208_a((JsonObject)object, (String)HOURS, (int)0));
        }
    };
    private static final Adapter<ReputationBar> REPUTATION_BAR_ADAPTER = new Adapter<ReputationBar>(){
        private static final String X = "x";
        private static final String Y = "y";
        private static final String REPUTATION_ID = "reputationId";

        @Override
        public JsonElement serialize(ReputationBar src) {
            return 2.object().add(REPUTATION_ID, src.getRepId()).add(X, src.getX()).add(Y, src.getY()).build();
        }

        @Override
        public ReputationBar deserialize(JsonElement json) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new ReputationBar(JSONUtils.func_151200_h((JsonObject)object, (String)REPUTATION_ID), JSONUtils.func_151203_m((JsonObject)object, (String)X), JSONUtils.func_151203_m((JsonObject)object, (String)Y), -1);
        }
    };
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private static final Type STRING_LIST_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final Pattern OTHER_QUEST_SET = Pattern.compile("^\\{(.*?)\\}\\[(.*)\\]$");
    public static Quest QUEST;
    private static Map<String, Quest> nameToQuestMap;
    private static List<ReputationBar> reputationBarList;
    private static Map<Quest, List<UUID>> requirementMapping;
    private static Map<Quest, List<UUID>> prerequisiteMapping;
    private static Map<Quest, List<UUID>> optionMapping;
    private static Map<Quest, List<UUID>> optionLinkMapping;
    private static Map<ReputationReward, String> reputationRewardMapping;
    private static final Adapter<ReputationReward> REPUTATION_REWARD_ADAPTER;
    public static final Adapter<Quest> QUEST_ADAPTER;
    public static final Adapter<QuestSet> QUEST_SET_ADAPTER;

    public static void postLoad() throws IOException {
        for (Map.Entry<Quest, List<UUID>> entry : prerequisiteMapping.entrySet()) {
            for (UUID link : entry.getValue()) {
                entry.getKey().addRequirement(link);
            }
        }
        prerequisiteMapping.clear();
        for (Map.Entry<Quest, List<UUID>> entry : optionLinkMapping.entrySet()) {
            for (UUID link : entry.getValue()) {
                entry.getKey().addOptionLink(link);
            }
        }
        optionLinkMapping.clear();
        for (Map.Entry<Object, Object> entry : reputationRewardMapping.entrySet()) {
            String rep = (String)entry.getValue();
            Reputation reputation = ReputationManager.getInstance().getReputations().get(rep);
            if (reputation == null) {
                throw new IOException("Failed to load reputation " + rep);
            }
            ((ReputationReward)entry.getKey()).setReward(reputation);
        }
        reputationRewardMapping.clear();
        for (Map.Entry<Object, Object> entry : QuestTaskAdapter.taskReputationListMap.entrySet()) {
            List<ReputationTask.Part> partList = ((ReputationTask)entry.getKey()).getSettings();
            partList.clear();
            for (QuestTaskAdapter.ReputationSettingConstructor constructor : (List)entry.getValue()) {
                ReputationTask.Part setting = constructor.constructReputationSetting();
                if (setting == null) continue;
                partList.add(setting);
            }
        }
        QuestTaskAdapter.taskReputationListMap.clear();
        nameToQuestMap.clear();
    }

    static {
        nameToQuestMap = new HashMap<String, Quest>();
        reputationBarList = new ArrayList<ReputationBar>();
        requirementMapping = new HashMap<Quest, List<UUID>>();
        prerequisiteMapping = new HashMap<Quest, List<UUID>>();
        optionMapping = new HashMap<Quest, List<UUID>>();
        optionLinkMapping = new HashMap<Quest, List<UUID>>();
        reputationRewardMapping = new HashMap<ReputationReward, String>();
        REPUTATION_REWARD_ADAPTER = new Adapter<ReputationReward>(){
            private static final String REPUTATION = "reputation";
            private static final String VALUE = "value";

            @Override
            public JsonElement serialize(ReputationReward src) {
                return 4.object().add(REPUTATION, ((Reputation)src.getReward()).getId()).add(VALUE, src.getValue()).build();
            }

            @Override
            public ReputationReward deserialize(JsonElement json) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                ReputationReward result = new ReputationReward(null, JSONUtils.func_151203_m((JsonObject)object, (String)VALUE));
                reputationRewardMapping.put(result, JSONUtils.func_151200_h((JsonObject)object, (String)REPUTATION));
                return result;
            }
        };
        QUEST_ADAPTER = new Adapter<Quest>(){
            private static final String UUID = "uuid";
            private static final String NAME = "name";
            private static final String DESCRIPTION = "description";
            private static final String X = "x";
            private static final String Y = "y";
            private static final String ICON = "icon";
            private static final String BIG_ICON = "bigicon";
            private static final String REQUIREMENTS = "requirements";
            private static final String PREREQUISITES = "prerequisites";
            private static final String OPTIONS = "options";
            private static final String OPTIONLINKS = "optionlinks";
            private static final String REPEAT = "repeat";
            private static final String TRIGGER = "trigger";
            private static final String TRIGGER_TASKS = "triggertasks";
            private static final String PARENT_REQUIREMENT = "parentrequirement";
            private static final String TASKS = "tasks";
            private static final String REWARDS = "reward";
            private static final String REWARDS_CHOICE = "rewardchoice";
            private static final String REWARDS_REPUTATION = "reputationrewards";
            private static final String REWARDS_COMMAND = "commandrewards";

            private JsonElement writeQuestList(List<Quest> quests) {
                Adapter.JsonArrayBuilder array = 5.array();
                if (!quests.isEmpty()) {
                    for (Quest quest : quests) {
                        array.add(quest.getQuestId().toString());
                    }
                }
                return array.build();
            }

            private JsonElement writeItemStackList(NonNullList<ItemStack> stacks) {
                Adapter.JsonArrayBuilder array = 5.array();
                if (stacks != null) {
                    for (ItemStack stack : stacks) {
                        if (stack == null) continue;
                        array.add(MinecraftAdapter.ITEM_STACK.serialize(stack));
                    }
                }
                return array.build();
            }

            @Override
            public JsonElement serialize(Quest src) {
                return 5.object().add(UUID, src.getQuestId().toString()).add(NAME, src.getName()).add(DESCRIPTION, src.getDescription()).add(X, src.getGuiX()).add(Y, src.getGuiY()).use(builder -> {
                    Adapter.JsonArrayBuilder array;
                    if (src.useBigIcon()) {
                        builder.add(BIG_ICON, true);
                    }
                    if (src.getIconStack() != null) {
                        builder.add(ICON, MinecraftAdapter.ITEM_STACK.serialize(src.getIconStack()));
                    }
                    if (src.getRepeatInfo().getType() != RepeatType.NONE) {
                        builder.add(REPEAT, REPEAT_INFO_ADAPTER.serialize(src.getRepeatInfo()));
                    }
                    if (src.getTriggerType() != TriggerType.NONE) {
                        builder.add(TRIGGER, src.getTriggerType().name());
                    }
                    if (src.getTriggerType().isUseTaskCount()) {
                        builder.add(TRIGGER_TASKS, src.getTriggerTasks());
                    }
                    if (src.getUseModifiedParentRequirement()) {
                        builder.add(PARENT_REQUIREMENT, src.getParentRequirementCount());
                    }
                    if (!src.getTasks().isEmpty()) {
                        array = 5.array();
                        for (QuestTask<?> task : src.getTasks()) {
                            array.add(QuestTaskAdapter.TASK_ADAPTER.serialize(task));
                        }
                        builder.add(TASKS, (JsonElement)array.build());
                    }
                    if (src.getReputationRewards() != null && !src.getReputationRewards().isEmpty()) {
                        array = 5.array();
                        for (ReputationReward reward : src.getReputationRewards()) {
                            array.add(REPUTATION_REWARD_ADAPTER.serialize(reward));
                        }
                        builder.add(REWARDS_REPUTATION, (JsonElement)array.build());
                    }
                }).add(PREREQUISITES, this.writeQuestList(src.getRequirements())).add(OPTIONLINKS, this.writeQuestList(src.getOptionLinks())).add(REWARDS, this.writeItemStackList(src.getReward())).add(REWARDS_CHOICE, this.writeItemStackList(src.getRewardChoice())).add(REWARDS_COMMAND, SaveHandler.GSON.toJsonTree((Object)src.getCommandRewardsAsStrings())).build();
            }

            @Override
            public Quest deserialize(JsonElement json) {
                Object icon;
                JsonObject object = json.getAsJsonObject();
                List requirement = Collections.emptyList();
                List options = Collections.emptyList();
                List prerequisites = Collections.emptyList();
                List optionLinks = Collections.emptyList();
                QUEST = new Quest(JSONUtils.func_151219_a((JsonObject)object, (String)NAME, (String)"Unnamed"), JSONUtils.func_151219_a((JsonObject)object, (String)DESCRIPTION, (String)"Unnamed quest"), JSONUtils.func_151208_a((JsonObject)object, (String)X, (int)0), JSONUtils.func_151208_a((JsonObject)object, (String)Y, (int)0), JSONUtils.func_151209_a((JsonObject)object, (String)BIG_ICON, (boolean)false));
                boolean hasUuid = object.has(UUID);
                if (hasUuid) {
                    QUEST.setId(UUID.fromString(JSONUtils.func_151200_h((JsonObject)object, (String)UUID)));
                }
                QUEST.setTriggerTasks(JSONUtils.func_151208_a((JsonObject)object, (String)TRIGGER_TASKS, (int)QUEST.getTriggerTasks()));
                QUEST.setParentRequirementCount(JSONUtils.func_151208_a((JsonObject)object, (String)PARENT_REQUIREMENT, (int)QUEST._getParentRequirementCount()));
                if (object.has(ICON) && !(icon = MinecraftAdapter.ITEM_STACK.deserialize(object.get(ICON))).func_190926_b()) {
                    QUEST.setIconStack((ItemStack)icon);
                }
                if (object.has(REQUIREMENTS)) {
                    requirement = (List)SaveHandler.GSON.fromJson(object.get(REQUIREMENTS), STRING_LIST_TYPE);
                }
                if (object.has(OPTIONS)) {
                    options = (List)SaveHandler.GSON.fromJson(object.get(OPTIONS), STRING_LIST_TYPE);
                }
                if (object.has(PREREQUISITES)) {
                    prerequisites = (List)SaveHandler.GSON.fromJson(object.get(PREREQUISITES), STRING_LIST_TYPE);
                }
                if (object.has(OPTIONLINKS)) {
                    optionLinks = (List)SaveHandler.GSON.fromJson(object.get(OPTIONLINKS), STRING_LIST_TYPE);
                }
                if (object.has(REPEAT)) {
                    QUEST.setRepeatInfo((RepeatInfo)REPEAT_INFO_ADAPTER.deserialize(object.get(REPEAT)));
                }
                if (object.has(TRIGGER)) {
                    QUEST.setTriggerType(TriggerType.valueOf(JSONUtils.func_151200_h((JsonObject)object, (String)TRIGGER)));
                }
                for (JsonElement element : JSONUtils.func_151213_a((JsonObject)object, (String)TASKS, (JsonArray)EMPTY_ARRAY)) {
                    QuestTaskAdapter.TASK_ADAPTER.deserialize(element);
                }
                QUEST.setReward(this.readItemStackList(JSONUtils.func_151213_a((JsonObject)object, (String)REWARDS, (JsonArray)EMPTY_ARRAY)));
                QUEST.setRewardChoice(this.readItemStackList(JSONUtils.func_151213_a((JsonObject)object, (String)REWARDS_CHOICE, (JsonArray)EMPTY_ARRAY)));
                if (object.has(REWARDS_REPUTATION)) {
                    ArrayList<ReputationReward> reputationRewards = new ArrayList<ReputationReward>();
                    for (JsonElement element : JSONUtils.func_151213_a((JsonObject)object, (String)REWARDS_REPUTATION, (JsonArray)EMPTY_ARRAY)) {
                        ReputationReward reward = (ReputationReward)REPUTATION_REWARD_ADAPTER.deserialize(element);
                        if (reward == null) continue;
                        reputationRewards.add(reward);
                    }
                    QUEST.setReputationRewards(reputationRewards);
                }
                if (object.has(REWARDS_COMMAND)) {
                    QUEST.setCommandRewards(((List)SaveHandler.GSON.fromJson(object.get(REWARDS_COMMAND), STRING_LIST_TYPE)).toArray(new String[0]));
                }
                if (hasUuid && QUEST.getQuestId() != null) {
                    this.optionalAdd(requirementMapping, requirement.stream().map(UUID::fromString).collect(Collectors.toList()));
                    this.optionalAdd(optionMapping, options.stream().map(UUID::fromString).collect(Collectors.toList()));
                    this.optionalAdd(prerequisiteMapping, prerequisites.stream().map(UUID::fromString).collect(Collectors.toList()));
                    this.optionalAdd(optionLinkMapping, optionLinks.stream().map(UUID::fromString).collect(Collectors.toList()));
                    return QUEST;
                }
                QuestSetsManager.getInstance().quests.remove(QUEST.getQuestId());
                return null;
            }

            private <T> void optionalAdd(Map<Quest, List<T>> map, List<T> list) {
                if (!list.isEmpty()) {
                    map.put(QUEST, list);
                }
            }

            private NonNullList<ItemStack> readItemStackList(JsonArray array) {
                NonNullList stacks = NonNullList.func_191196_a();
                for (JsonElement element : array) {
                    ItemStack stack = MinecraftAdapter.ITEM_STACK.deserialize(element);
                    if (stack.func_190926_b()) continue;
                    stacks.add((Object)stack);
                }
                return stacks;
            }
        };
        QUEST_SET_ADAPTER = new Adapter<QuestSet>(){
            private static final String NAME = "name";
            private static final String DESCRIPTION = "description";
            private static final String QUESTS = "quests";
            private static final String REPUTATION_BAR = "reputationBar";
            private static final String REPUTATION_BAR_OLD = "reputation";

            private QuestSet removeQuestsRaw(List<Quest> quests) {
                for (Quest quest : quests) {
                    QuestSetsManager.getInstance().quests.remove(quest.getQuestId());
                }
                return null;
            }

            @Override
            public JsonElement serialize(QuestSet src) {
                reputationBarList.clear();
                return 6.object().add(NAME, src.getName()).add(QUESTS, (JsonElement)6.array().use(builder -> {
                    for (Quest quest : src.getQuests().values()) {
                        builder.add(QUEST_ADAPTER.serialize(quest));
                    }
                }).build()).add(REPUTATION_BAR, (JsonElement)6.array().use(builder -> {
                    for (ReputationBar bar : src.getReputationBars()) {
                        builder.add(REPUTATION_BAR_ADAPTER.serialize(bar));
                    }
                }).build()).use(builder -> {
                    if (!src.getDescription().equalsIgnoreCase("No description")) {
                        builder.add(DESCRIPTION, src.getDescription());
                    }
                }).build();
            }

            @Override
            public QuestSet deserialize(JsonElement json) throws JsonParseException {
                requirementMapping.clear();
                optionMapping.clear();
                reputationBarList.clear();
                ArrayList<Quest> quests = new ArrayList<Quest>();
                JsonObject object = json.getAsJsonObject();
                String name = JSONUtils.func_151200_h((JsonObject)object, (String)NAME);
                String description = JSONUtils.func_151219_a((JsonObject)object, (String)DESCRIPTION, (String)"No description");
                for (JsonElement element : JSONUtils.func_151214_t((JsonObject)object, (String)QUESTS)) {
                    Quest quest = (Quest)QUEST_ADAPTER.fromJsonTree(element);
                    if (quest == null) continue;
                    quests.add(quest);
                }
                for (JsonElement element : JSONUtils.func_151214_t((JsonObject)object, (String)REPUTATION_BAR)) {
                    reputationBarList.add(REPUTATION_BAR_ADAPTER.deserialize(element));
                }
                QuestSet set = null;
                for (QuestSet questSet : Quest.getQuestSets()) {
                    if (!questSet.getName().equals(name)) continue;
                    set = questSet;
                    set.setDescription(description);
                    break;
                }
                if (name != null && description != null && set == null) {
                    set = new QuestSet(name, description);
                    Quest.getQuestSets().add(set);
                    SaveHelper.add(EditType.SET_CREATE);
                }
                if (set != null) {
                    for (Quest quest : quests) {
                        quest.setQuestSet(set);
                    }
                    for (Map.Entry entry : requirementMapping.entrySet()) {
                        for (UUID i : (List)entry.getValue()) {
                            ((Quest)entry.getKey()).addRequirement(i);
                        }
                    }
                    for (Map.Entry entry : optionMapping.entrySet()) {
                        for (UUID i : (List)entry.getValue()) {
                            ((Quest)entry.getKey()).addOptionLink(i);
                        }
                    }
                    for (ReputationBar reputationBar : reputationBarList) {
                        for (ReputationBar r : new ArrayList<ReputationBar>(set.getReputationBars())) {
                            if (!r.sameLocation(reputationBar)) continue;
                            set.removeRepBar(r);
                        }
                        set.addRepBar(reputationBar);
                    }
                    return set;
                }
                return this.removeQuestsRaw(quests);
            }
        };
    }
}

