/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;

public class PatchedNbtOps
extends NBTDynamicOps {
    public static final PatchedNbtOps INSTANCE = new PatchedNbtOps();

    public INBT createList(Stream<INBT> stream) {
        List<INBT> elements = stream.collect(Collectors.toList());
        if (elements.isEmpty()) {
            return new ListNBT();
        }
        if (elements.stream().allMatch(this::canBeInByteArray)) {
            return new ByteArrayNBT(elements.stream().map(tag -> ((NumberNBT)tag).func_150290_f()).collect(Collectors.toList()));
        }
        if (elements.stream().allMatch(this::canBeInIntArray)) {
            return new IntArrayNBT(elements.stream().map(tag -> ((NumberNBT)tag).func_150287_d()).collect(Collectors.toList()));
        }
        if (elements.stream().allMatch(this::canBeInLongArray)) {
            return new LongArrayNBT(elements.stream().map(tag -> ((NumberNBT)tag).func_150291_c()).collect(Collectors.toList()));
        }
        ListNBT listTag = new ListNBT();
        elements.forEach(tag -> {
            if (!(tag instanceof EndNBT)) {
                listTag.add(tag);
            }
        });
        return listTag;
    }

    public boolean canBeInLongArray(INBT tag) {
        return tag instanceof LongNBT || this.canBeInIntArray(tag);
    }

    public boolean canBeInIntArray(INBT tag) {
        return tag instanceof IntNBT || tag instanceof ShortNBT || this.canBeInByteArray(tag);
    }

    public boolean canBeInByteArray(INBT tag) {
        return tag instanceof ByteNBT;
    }
}

