/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.PatchedNbtOps;
import hardcorequesting.common.forge.platform.FluidStack;
import hardcorequesting.common.forge.util.Fraction;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftAdapter {
    public static final Adapter<ItemStack> ITEM_STACK = new Adapter<ItemStack>(){

        @Override
        public JsonElement serialize(ItemStack src) {
            if (src.func_190926_b()) {
                return 1.nullVal();
            }
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("id", Registry.field_212630_s.func_177774_c((Object)src.func_77973_b()).toString());
            jsonObj.addProperty("Count", (Number)src.func_190916_E());
            CompoundNBT tag = src.func_77978_p();
            if (tag != null) {
                jsonObj.add("tag", COMPOUND_TAG.serialize(tag));
            }
            return jsonObj;
        }

        @Override
        @NotNull
        public ItemStack deserialize(JsonElement json) {
            if (json.isJsonNull()) {
                return ItemStack.field_190927_a;
            }
            JsonObject jsonObj = json.getAsJsonObject();
            Item item = (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObj, (String)"id")));
            int count = JSONUtils.func_151208_a((JsonObject)jsonObj, (String)"Count", (int)1);
            ItemStack stack = new ItemStack((IItemProvider)item, count);
            if (jsonObj.has("tag")) {
                stack.func_77982_d(COMPOUND_TAG.deserialize(jsonObj.get("tag")));
            }
            return stack;
        }
    };
    public static final Adapter<FluidStack> FLUID = new Adapter<FluidStack>(){
        private static final String FLUID = "fluid";
        private static final String VOLUME = "volume";

        @Override
        public JsonElement serialize(FluidStack src) {
            return 2.object().add(FLUID, Registry.field_212619_h.func_177774_c((Object)src.getFluid()).toString()).add(VOLUME, (JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)src.getAmount().toNbt())).build();
        }

        @Override
        public FluidStack deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            Fluid fluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)FLUID)));
            Fraction amount = Fraction.fromNbt((CompoundNBT)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)object.get(VOLUME)));
            return HardcoreQuestingCore.platform.createFluidStack(fluid, amount);
        }
    };
    public static final Adapter<CompoundNBT> COMPOUND_TAG = new Adapter<CompoundNBT>(){

        @Override
        public JsonElement serialize(CompoundNBT src) {
            return new JsonPrimitive(src.toString());
        }

        @Override
        @Nullable
        public CompoundNBT deserialize(JsonElement json) {
            if (json.isJsonObject()) {
                return (CompoundNBT)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)PatchedNbtOps.INSTANCE, (Object)json);
            }
            try {
                return JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)json, (String)"tag"));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(e.getMessage());
            }
        }
    };
}

