/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.death.DeathStat;
import hardcorequesting.common.forge.death.DeathType;
import hardcorequesting.common.forge.io.adapter.Adapter;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.JSONUtils;

public class DeathAdapter {
    public static final Adapter<DeathStat> DEATH_STATS_ADAPTER = new Adapter<DeathStat>(){
        private static final String DEATHS = "deaths";
        private static final String NAME = "name";

        @Override
        public JsonElement serialize(DeathStat src) {
            return 1.object().add(src.getUuid().toString(), (JsonElement)1.array().use(builder -> Arrays.stream(DeathType.values()).forEach(deathType -> builder.add(src.getDeaths((DeathType)((Object)((Object)deathType)))))).build()).add(NAME, src.getCachedName()).build();
        }

        @Override
        public DeathStat deserialize(JsonElement jsonElement) {
            if (!jsonElement.isJsonObject()) {
                HardcoreQuestingCore.LOGGER.error((Object)new JsonParseException("JsonElement for 'Death Stat' is not a JsonObject but '" + jsonElement.getClass().getName() + "'!"));
                return null;
            }
            JsonObject json = jsonElement.getAsJsonObject();
            for (Map.Entry entry : json.entrySet()) {
                JsonArray array;
                UUID uuid;
                try {
                    uuid = UUID.fromString((String)entry.getKey());
                }
                catch (IllegalArgumentException e) {
                    HardcoreQuestingCore.LOGGER.error("Json key for 'Death Stat' can't be parsed to UUID!", (Throwable)e);
                    continue;
                }
                DeathStat deathStat = new DeathStat(uuid);
                deathStat.setCachedName(JSONUtils.func_151219_a((JsonObject)json, (String)NAME, null));
                if (((JsonElement)entry.getValue()).isJsonArray()) {
                    array = ((JsonElement)entry.getValue()).getAsJsonArray();
                } else if (((JsonElement)entry.getValue()).isJsonObject()) {
                    JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                    deathStat.setCachedName(JSONUtils.func_151219_a((JsonObject)jsonObject, (String)NAME, (String)deathStat.getCachedName()));
                    array = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)DEATHS);
                } else {
                    HardcoreQuestingCore.LOGGER.error("Json value for 'Death Stat' with uuid '" + deathStat.getUuid() + "' isn't a JsonObject or JsonArray!");
                    continue;
                }
                int i = 0;
                for (JsonElement element : array) {
                    if (i >= DeathType.values().length) {
                        HardcoreQuestingCore.LOGGER.error("JsonArray for 'Death Stat' with uuid '" + deathStat.getUuid() + "' exceeded its expected size!");
                        break;
                    }
                    if (JSONUtils.func_188175_b((JsonElement)element)) {
                        deathStat.increaseDeath(DeathType.values()[i++], element.getAsInt(), false);
                        continue;
                    }
                    HardcoreQuestingCore.LOGGER.error("JsonArray for 'Death Stat' with uuid '" + deathStat.getUuid() + "' does contain a invalid non-integer type!");
                }
                return deathStat;
            }
            HardcoreQuestingCore.LOGGER.error("Can't parse 'DeathStat' from json file. No valid key-value pair found!");
            return null;
        }
    };
}

