/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.event;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;

public class PlayerTracker {
    public static PlayerTracker instance;
    public static final String HQ_TAG = "HardcoreQuesting";
    public static final String RECEIVED_BOOK = "questBook";

    public PlayerTracker() {
        instance = this;
    }

    public int getRemainingLives(PlayerEntity sender) {
        return QuestingDataManager.getInstance().getQuestingData(sender).getLives();
    }

    public void onPlayerLogin(ServerPlayerEntity player) {
        CompoundNBT tags;
        QuestLine.sendDataToClient(player);
        QuestingDataManager questingData = QuestingDataManager.getInstance();
        if (!questingData.hasData((PlayerEntity)player)) {
            DeathStatsManager.getInstance().resync();
        }
        if (questingData.isHardcoreActive()) {
            this.sendLoginMessage((PlayerEntity)player);
        } else if (HQMConfig.getInstance().Message.NO_HARDCORE_MESSAGE) {
            player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.noHardcore", new Object[0]), Util.field_240973_b_);
        }
        if (!HQMUtil.isGameSingleplayer()) {
            Quest.setEditMode(false);
        }
        if ((tags = HardcoreQuestingCore.platform.getPlayerExtraTag((PlayerEntity)player)).func_74764_b(HQ_TAG)) {
            if (tags.func_74775_l(HQ_TAG).func_74767_n(RECEIVED_BOOK)) {
                questingData.getQuestingData((PlayerEntity)player).receivedBook = true;
            }
            if (!questingData.isQuestActive()) {
                tags.func_82580_o(HQ_TAG);
            }
        }
        QuestSet.loginReset();
        questingData.spawnBook((PlayerEntity)player);
    }

    private void sendLoginMessage(PlayerEntity player) {
        player.func_145747_a((ITextComponent)Translator.translatable("hqm.message.hardcore", new Object[0]).func_240702_b_(" ").func_230529_a_((ITextComponent)Translator.pluralTranslated(this.getRemainingLives(player) != 1, "hqm.message.livesLeft", this.getRemainingLives(player))), Util.field_240973_b_);
    }
}

