/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.event;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.QuestTask;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.TriConsumer;

public class EventTrigger {
    private static EventTrigger instance;
    private List<QuestTask>[] registeredTasks = new List[Type.values().length];

    public EventTrigger() {
        for (int i = 0; i < this.registeredTasks.length; ++i) {
            this.registeredTasks[i] = new CopyOnWriteArrayList<QuestTask>();
        }
        HardcoreQuestingCore.platform.registerOnServerTick(this::onServerTick);
        HardcoreQuestingCore.platform.registerOnWorldTick(world -> {
            for (PlayerEntity player : world.func_217369_A()) {
                if (!(player instanceof ServerPlayerEntity)) continue;
                this.onPlayerTick((ServerPlayerEntity)player);
            }
        });
        HardcoreQuestingCore.platform.registerOnUseItem((TriConsumer<PlayerEntity, World, Hand>)((TriConsumer)this::onItemUsed));
        HardcoreQuestingCore.platform.registerOnBlockUse(this::onBlockUsed);
        HardcoreQuestingCore.platform.registerOnBlockPlace(this::onBlockPlaced);
        HardcoreQuestingCore.platform.registerOnBlockBreak(this::onBlockBreak);
        HardcoreQuestingCore.platform.registerOnItemPickup(this::onItemPickUp);
        HardcoreQuestingCore.platform.registerOnCrafting(this::onCrafting);
        HardcoreQuestingCore.platform.registerOnAnvilCrafting(this::onAnvilCrafting);
        HardcoreQuestingCore.platform.registerOnSmelting(this::onSmelting);
        HardcoreQuestingCore.platform.registerOnAdvancement(this::onAdvancement);
        HardcoreQuestingCore.platform.registerOnAnimalTame(this::onAnimalTame);
        instance = this;
    }

    public static EventTrigger instance() {
        return instance;
    }

    public void clear() {
        for (List<QuestTask> registeredTask : this.registeredTasks) {
            registeredTask.clear();
        }
    }

    public void add(QuestTask task, Type ... types) {
        for (Type type : types) {
            this.registeredTasks[type.ordinal()].add(task);
        }
    }

    public void remove(QuestTask task) {
        for (List<QuestTask> registeredTask : this.registeredTasks) {
            registeredTask.remove(task);
        }
    }

    public void onPlayerLogin(ServerPlayerEntity entity) {
        for (List<QuestTask> list : this.registeredTasks) {
            list.removeIf(q -> !q.isValid());
        }
        QuestingDataManager questingData = QuestingDataManager.getInstance();
        if (questingData.isQuestActive()) {
            questingData.spawnBook((PlayerEntity)entity);
        }
    }

    public void onServerTick(MinecraftServer server) {
        for (QuestTask task : this.getTasks(Type.SERVER)) {
            task.onServerTick(server);
        }
    }

    public void onPlayerTick(ServerPlayerEntity playerEntity) {
        for (QuestTask task : this.getTasks(Type.PLAYER)) {
            task.onPlayerTick(playerEntity);
        }
    }

    public void onLivingDeath(LivingEntity entity, DamageSource source) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.DEATH)) {
            task.onLivingDeath(entity, source);
        }
    }

    public void onCrafting(PlayerEntity player, ItemStack stack) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.CRAFTING)) {
            task.onCrafting(player, stack);
        }
    }

    public void onAnvilCrafting(PlayerEntity player, ItemStack stack) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.CRAFTING)) {
            task.onCrafting(player, stack);
        }
    }

    public void onSmelting(PlayerEntity player, ItemStack stack) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.CRAFTING)) {
            task.onCrafting(player, stack);
        }
    }

    public void onItemPickUp(PlayerEntity playerEntity, ItemStack stack) {
        if (playerEntity.field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.PICK_UP)) {
            task.onItemPickUp(playerEntity, stack);
        }
    }

    public void onBookOpening(BookOpeningEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.OPEN_BOOK)) {
            task.onOpenBook(event);
        }
    }

    public void onQuestComplete(QuestCompletedEvent event) {
        if (((QuestCompletedEvent)event).player.field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.QUEST_COMPLETED)) {
            task.onQuestCompleted(event);
        }
    }

    public void onQuestSelected(QuestSelectedEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.QUEST_SELECTED)) {
            task.onQuestSelected(event);
        }
    }

    public void onReputationChange(ReputationEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.REPUTATION_CHANGE)) {
            task.onReputationChange(event);
        }
    }

    public void onAnimalTame(PlayerEntity tamer, Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.ANIMAL_TAME)) {
            task.onAnimalTame(tamer, entity);
        }
    }

    public void onAdvancement(ServerPlayerEntity playerEntity, Advancement advancement) {
        for (QuestTask task : this.getTasks(Type.ADVANCEMENT)) {
            task.onAdvancement(playerEntity);
        }
    }

    public void onBlockBreak(IWorld world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.BLOCK_BROKEN)) {
            task.onBlockBroken(pos, state, player);
        }
    }

    public void onBlockPlaced(World world, BlockPos pos, BlockState state, LivingEntity placer) {
        if (world.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.BLOCK_PLACED)) {
            task.onBlockPlaced(world, state, placer);
        }
    }

    private void onItemUsed(PlayerEntity playerEntity, World world, Hand hand) {
        if (world.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.ITEM_USED)) {
            task.onItemUsed(playerEntity, world, hand);
        }
    }

    private void onBlockUsed(PlayerEntity playerEntity, World world, Hand hand, BlockPos pos, Direction face) {
        if (world.field_72995_K) {
            return;
        }
        for (QuestTask task : this.getTasks(Type.ITEM_USED)) {
            task.onBlockUsed(playerEntity, world, hand);
        }
    }

    private List<QuestTask> getTasks(Type type) {
        this.registeredTasks[type.ordinal()].removeIf(task -> !task.isValid());
        return this.registeredTasks[type.ordinal()];
    }

    public static class ReputationEvent {
        private PlayerEntity player;

        public ReputationEvent(PlayerEntity player) {
            this.player = player;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }
    }

    public static class QuestSelectedEvent
    extends QuestCompletedEvent {
        public QuestSelectedEvent(PlayerEntity player, UUID questSelected) {
            super(player, questSelected);
        }

        public UUID getQuestSelected() {
            return this.getQuestCompleted();
        }
    }

    public static class QuestCompletedEvent {
        private UUID questCompleted;
        private PlayerEntity player;

        public QuestCompletedEvent(PlayerEntity player, UUID questCompleted) {
            this.player = player;
            this.questCompleted = questCompleted;
        }

        public UUID getQuestCompleted() {
            return this.questCompleted;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }
    }

    public static class BookOpeningEvent {
        private UUID playerUUID;
        private boolean isOpBook;
        private boolean isRealName;

        public BookOpeningEvent(UUID playerUUID, boolean isOpBook, boolean isRealName) {
            this.playerUUID = playerUUID;
            this.isOpBook = isOpBook;
            this.isRealName = isRealName;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public boolean isOpBook() {
            return this.isOpBook;
        }

        public boolean isRealName() {
            return this.isRealName;
        }

        public PlayerEntity getPlayer() {
            return QuestingData.getPlayer(this.playerUUID);
        }
    }

    public static enum Type {
        SERVER,
        PLAYER,
        DEATH,
        CRAFTING,
        PICK_UP,
        OPEN_BOOK,
        REPUTATION_CHANGE,
        ANIMAL_TAME,
        ADVANCEMENT,
        QUEST_COMPLETED,
        QUEST_SELECTED,
        BLOCK_PLACED,
        BLOCK_BROKEN,
        ITEM_USED;

    }
}

