/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.death;

import hardcorequesting.common.forge.death.DeathStatsManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;

public enum DeathType {
    LAVA("lava"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("lava");
        }
    }
    ,
    FIRE("fire"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76347_k();
        }
    }
    ,
    SUFFOCATION("suffocation"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("inWall");
        }
    }
    ,
    THORNS("thorns"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("thorns") || source.field_76373_n.equals("cactus");
        }
    }
    ,
    DROWNING("drowning"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("drown");
        }
    }
    ,
    STARVATION("starvation"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("starve");
        }
    }
    ,
    FALL("fall"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("fall");
        }
    }
    ,
    VOID("void"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("outOfWorld");
        }
    }
    ,
    CRUSHED("crushed"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("anvil") || source.field_76373_n.equals("fallingBlock");
        }
    }
    ,
    EXPLOSION("explosions"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_94541_c();
        }
    }
    ,
    MONSTER("monsters"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("mob") || source.func_76346_g() instanceof LivingEntity;
        }
    }
    ,
    PLAYER("otherPlayers"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.field_76373_n.equals("player") || source.func_76346_g() instanceof PlayerEntity;
        }
    }
    ,
    MAGIC("magic"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_82725_o();
        }
    }
    ,
    HQM("rottenHearts"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return false;
        }
    }
    ,
    OTHER("other"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return true;
        }
    };

    private String name;

    private DeathType(String name) {
        this.name = name;
    }

    public static void onDeath(PlayerEntity player, DamageSource source) {
        if (source != null && source.field_76373_n != null) {
            for (DeathType deathType : DeathType.values()) {
                if (!deathType.isSourceValid(source)) continue;
                deathType.onDeath(player);
                break;
            }
        } else {
            OTHER.onDeath(player);
        }
    }

    public void onDeath(PlayerEntity player) {
        DeathStatsManager.getInstance().getDeathStat(player).increaseDeath(this);
    }

    abstract boolean isSourceValid(DamageSource var1);

    public String getName() {
        return I18n.func_135052_a((String)("hqm.deathType." + this.name), (Object[])new Object[0]);
    }

    public static DeathType getClamped(int i) {
        return DeathType.values()[MathHelper.func_76125_a((int)i, (int)0, (int)DeathType.values().length)];
    }
}

