/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.death;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.death.DeathStat;
import hardcorequesting.common.forge.death.DeathType;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.DeathStatsMessage;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class DeathStatsManager
extends SimpleSerializable {
    private static final Comparator<DeathStat> DEATH_COMPARATOR = Comparator.comparingInt(DeathStat::getTotalDeaths);
    private final Map<UUID, DeathStat> deathMap = new HashMap<UUID, DeathStat>();
    private DeathStat[] clientDeathList;
    private DeathStat clientBest;
    private DeathStat clientTotal;

    public DeathStatsManager(QuestLine parent) {
        super(parent);
    }

    public static DeathStatsManager getInstance() {
        return QuestLine.getActiveQuestLine().deathStatsManager;
    }

    public DeathStat getDeathStat(PlayerEntity player) {
        return this.getDeathStat(player.func_110124_au());
    }

    public DeathStat getDeathStat(UUID uuid) {
        return this.deathMap.computeIfAbsent(uuid, DeathStat::new);
    }

    public DeathStat[] getDeathStats() {
        return this.clientDeathList;
    }

    private void updateClientDeathList() {
        this.clientDeathList = new DeathStat[this.deathMap.size()];
        int id = 0;
        for (DeathStat deathStat : this.deathMap.values()) {
            deathStat.totalDeaths = -1;
            this.clientDeathList[id++] = deathStat;
        }
        Arrays.sort(this.clientDeathList, DEATH_COMPARATOR);
        this.clientBest = new DeathStat.DeathStatBest(this.clientDeathList);
        this.clientTotal = new DeathStat.DeathStatTotal(this.clientDeathList);
    }

    public DeathStat getBest() {
        return this.clientBest;
    }

    public DeathStat getTotal() {
        return this.clientTotal;
    }

    public void resync() {
        NetworkManager.sendToAllPlayers(new DeathStatsMessage(HardcoreQuestingCore.platform.isClient()));
    }

    public List<DeathStat> getDeathStatsList() {
        return Lists.newArrayList(this.deathMap.values());
    }

    @Override
    public String saveToString() {
        return SaveHandler.save(this.getDeathStatsList(), new TypeToken<List<DeathStat>>(){}.getType());
    }

    public void writeSimplified(PacketBuffer buf) {
        buf.writeInt(this.deathMap.size());
        for (Map.Entry<UUID, DeathStat> entry : this.deathMap.entrySet()) {
            buf.func_179252_a(entry.getKey());
            Map<DeathType, Integer> deaths = entry.getValue().deaths;
            int count = 0;
            DeathType[] deathTypeArray = deaths.values().iterator();
            while (deathTypeArray.hasNext()) {
                int death = deathTypeArray.next();
                if (death == 0) continue;
                ++count;
            }
            buf.writeByte(count);
            for (DeathType type : DeathType.values()) {
                int deathCount = deaths.get((Object)type);
                if (deathCount == 0) continue;
                buf.writeByte(type.ordinal());
                buf.writeShort((int)((short)deathCount));
            }
        }
    }

    public Map<UUID, DeathStat> readSimplified(PacketBuffer buf) {
        HashMap<UUID, DeathStat> deathMap = new HashMap<UUID, DeathStat>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            UUID uuid = buf.func_179253_g();
            DeathStat stat = new DeathStat(uuid);
            int count = buf.readByte();
            for (int j = 0; j < count; ++j) {
                DeathType type = DeathType.getClamped(buf.readByte());
                stat.increaseDeath(type, buf.readShort(), false);
            }
            deathMap.put(uuid, stat);
        }
        return deathMap;
    }

    @Override
    public String filePath() {
        return "deaths.json";
    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public void loadFromString(Optional<String> string) {
        this.deathMap.clear();
        string.flatMap(s -> SaveHandler.load(s, new TypeToken<List<DeathStat>>(){}.getType())).ifPresent(list -> list.forEach(stat -> this.deathMap.put(stat.getUuid(), (DeathStat)stat)));
        if (HardcoreQuestingCore.platform.isClient()) {
            this.updateClientDeathList();
        }
    }
}

