/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.death;

import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.death.DeathType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DeathStat {
    private static final Map<DeathType, Comparator<DeathStat>> deathTypeComparator = new EnumMap<DeathType, Comparator<DeathStat>>(DeathType.class);
    protected final Map<DeathType, Integer> deaths = new EnumMap<DeathType, Integer>(DeathType.class);
    private final UUID uuid;
    private String cachedName;
    int totalDeaths;

    public DeathStat(UUID uuid) {
        for (DeathType type : DeathType.values()) {
            this.deaths.put(type, 0);
        }
        this.totalDeaths = -1;
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getName() throws IllegalArgumentException {
        PlayerEntity player;
        if (Minecraft.func_71410_x().field_71441_e != null && (player = Minecraft.func_71410_x().field_71441_e.func_217371_b(this.uuid)) != null) {
            this.cachedName = player.func_195047_I_();
            return this.cachedName;
        }
        if (this.cachedName != null) {
            return this.cachedName;
        }
        return "<invalid>";
    }

    public String getCachedName() {
        return this.cachedName;
    }

    public void setCachedName(String cachedName) {
        this.cachedName = cachedName;
    }

    public String getDescription(DeathType type) {
        return type.getName() + ": " + this.deaths.get((Object)type);
    }

    public void increaseDeath(DeathType type) {
        this.increaseDeath(type, 1, true);
    }

    public void increaseDeath(DeathType type, int count, boolean resync) {
        this.deaths.merge(type, count, Integer::sum);
        this.totalDeaths = -1;
        if (resync) {
            DeathStatsManager.getInstance().resync();
        }
    }

    public int getTotalDeaths() {
        if (this.totalDeaths == -1) {
            this.totalDeaths = 0;
            for (int death : this.deaths.values()) {
                this.totalDeaths += death;
            }
        }
        return this.totalDeaths;
    }

    public int getDeaths(DeathType type) {
        return this.deaths.get((Object)type);
    }

    static {
        for (DeathType type : DeathType.values()) {
            deathTypeComparator.put(type, Comparator.comparingInt(stat -> stat.getDeaths(type)));
        }
    }

    public static class DeathStatTotal
    extends DeathStat {
        public Map<DeathType, Integer> counts = new EnumMap<DeathType, Integer>(DeathType.class);

        public DeathStatTotal(DeathStat[] clientDeathList) {
            super(null);
            for (DeathType type : DeathType.values()) {
                int counter = 0;
                for (DeathStat deathStat : clientDeathList) {
                    this.deaths.merge(type, deathStat.getDeaths(type), Integer::sum);
                    if (deathStat.getDeaths(type) <= 0) continue;
                    ++counter;
                }
                this.counts.put(type, counter);
            }
        }

        @Override
        public String getDescription(DeathType type) {
            int count = this.counts.get((Object)type);
            return super.getDescription(type) + "\n\n" + (count == 0 ? (Object)((Object)GuiColor.RED) + I18n.func_135052_a((String)"hqm.deathStat.noOneDied", (Object[])new Object[0]) : GuiColor.GREEN.toString() + count + " " + I18n.func_135052_a((String)("hqm.deathStat.player" + (count == 1 ? "" : "s")), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"hqm.deathStat.diedThisWay", (Object[])new Object[0]));
        }

        @Override
        public String getName() {
            return I18n.func_135052_a((String)"hqm.deathStat.everyone", (Object[])new Object[0]);
        }
    }

    public static class DeathStatBest
    extends DeathStat {
        private static final String[] colourPrefixes = new String[]{GuiColor.YELLOW.toString(), GuiColor.LIGHT_GRAY.toString(), GuiColor.ORANGE.toString()};
        private static final String[] placePrefixes = new String[]{"first", "second", "third"};
        private final Map<DeathType, String> messages = new EnumMap<DeathType, String>(DeathType.class);

        public DeathStatBest(DeathStat[] clientDeathList) {
            super(null);
            for (DeathType type : DeathType.values()) {
                Arrays.sort(clientDeathList, (Comparator)deathTypeComparator.get((Object)type));
                if (clientDeathList.length < 1) {
                    this.deaths.put(type, 0);
                    this.messages.put(type, (Object)((Object)GuiColor.RED) + I18n.func_135052_a((String)"hqm.deathStat.noOneDied", (Object[])new Object[0]));
                    continue;
                }
                this.deaths.put(type, clientDeathList[0].getDeaths(type));
                StringBuilder builder = new StringBuilder();
                int currentValue = 0;
                int standing = 0;
                for (int j = 0; j < clientDeathList.length; ++j) {
                    int value = clientDeathList[j].getDeaths(type);
                    if (value < currentValue) {
                        standing = j;
                        if (value == 0 || standing >= 3) break;
                    }
                    currentValue = value;
                    if (j != 0) {
                        builder.append("\n");
                    }
                    builder.append(colourPrefixes[standing]).append(I18n.func_135052_a((String)("hqm.deathStat." + placePrefixes[standing]), (Object[])new Object[0]));
                    builder.append((Object)((Object)GuiColor.WHITE) + " ").append(clientDeathList[j].getName()).append(": ").append(clientDeathList[j].getDeaths(type));
                }
                this.messages.put(type, builder.toString());
            }
        }

        @Override
        public String getName() {
            return I18n.func_135052_a((String)"hqm.deathStat.worstPlayers", (Object[])new Object[0]);
        }

        @Override
        public String getDescription(DeathType type) {
            return type.getName() + "\n\n" + this.messages.get((Object)type);
        }
    }
}

