/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.commands.CommandHandler;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LivesSubCommand
implements CommandHandler.SubCommand {
    @Override
    public ArgumentBuilder<CommandSource, ?> build(LiteralArgumentBuilder<CommandSource> builder) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(source -> source.func_197034_c(4))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("hqm.message.noHardcoreYet"));
                return 1;
            }
            for (ServerPlayerEntity player : EntityArgument.func_197090_e((CommandContext)context, (String)"targets")) {
                this.addLivesTo((CommandSource)context.getSource(), (PlayerEntity)player, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"));
            }
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("hqm.message.noHardcoreYet"));
                return 1;
            }
            for (ServerPlayerEntity player : EntityArgument.func_197090_e((CommandContext)context, (String)"targets")) {
                this.addLivesTo((CommandSource)context.getSource(), (PlayerEntity)player, 1);
            }
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("hqm.message.noHardcoreYet"));
                return 1;
            }
            if (((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity) {
                this.addLivesTo((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), 1);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("hqm.message.noHardcoreYet"));
                return 1;
            }
            for (ServerPlayerEntity player : EntityArgument.func_197090_e((CommandContext)context, (String)"targets")) {
                this.removeLivesFrom((CommandSource)context.getSource(), (PlayerEntity)player, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"));
            }
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("hqm.message.noHardcoreYet"));
                return 1;
            }
            for (ServerPlayerEntity player : EntityArgument.func_197090_e((CommandContext)context, (String)"targets")) {
                this.removeLivesFrom((CommandSource)context.getSource(), (PlayerEntity)player, 1);
            }
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("hqm.message.noHardcoreYet"));
                return 1;
            }
            if (((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity) {
                this.removeLivesFrom((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), 1);
            }
            return 1;
        }))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("hqm.message.noHardcoreYet"));
                return 1;
            }
            this.currentLives((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"targets"));
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("hqm.message.noHardcoreYet"));
                return 1;
            }
            if (((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity) {
                this.currentLives((PlayerEntity)((CommandSource)context.getSource()).func_197022_f());
            }
            return 1;
        });
    }

    @Override
    public int[] getSyntaxOptions(CommandContext<CommandSource> context) {
        return new int[]{0, 1, 2, 3};
    }

    private void removeLivesFrom(CommandSource source, PlayerEntity player, int amount) {
        QuestingDataManager.getInstance().getQuestingData(player).removeLives(player, amount);
        this.sendTranslatableChat(source, amount != 1, "hqm.message.removeLivesFrom", amount, player.func_195047_I_());
        if (source.func_197022_f() != player) {
            this.sendTranslatableChat(player.func_195051_bN(), amount != 1, "hqm.message.removeLivesBy", amount, source.func_197037_c());
        }
        this.currentLives(player);
    }

    private void addLivesTo(CommandSource source, PlayerEntity player, int amount) {
        QuestingDataManager questingDataManager = QuestingDataManager.getInstance();
        if (questingDataManager.getQuestingData(player).getRawLives() + amount <= HQMConfig.getInstance().Hardcore.MAX_LIVES) {
            questingDataManager.getQuestingData(player).addLives(player, amount);
            this.sendTranslatableChat(source, amount != 1, "hqm.message.addLivesTo", amount, player.func_195047_I_());
            if (source.func_197022_f() != player) {
                this.sendTranslatableChat(player.func_195051_bN(), amount != 1, "hqm.message.addLivesBy", amount, source.func_197037_c());
            }
        } else {
            questingDataManager.getQuestingData(player).addLives(player, amount);
            this.sendTranslatableChat(source, "hqm.message.cantGiveMoreLives", player.func_195047_I_(), HQMConfig.getInstance().Hardcore.MAX_LIVES);
            this.sendTranslatableChat(source, "hqm.massage.setLivesInstead", player.func_195047_I_(), HQMConfig.getInstance().Hardcore.MAX_LIVES);
            if (source.func_197022_f() != player) {
                this.sendTranslatableChat(player.func_195051_bN(), "hqm.massage.setLivesBy", HQMConfig.getInstance().Hardcore.MAX_LIVES, source.func_197037_c());
            }
        }
        this.currentLives(player);
    }

    private void getPlayerLives(CommandSource source, String playerName) throws CommandException {
        ServerPlayerEntity player = HardcoreQuestingCore.getServer().func_184103_al().func_152612_a(playerName);
        if (player == null) {
            throw new CommandException((ITextComponent)new TranslationTextComponent("hqm.message.noPlayer"));
        }
        int lives = QuestingDataManager.getInstance().getQuestingData((PlayerEntity)player).getLives();
        this.sendTranslatableChat(source, lives != 1, "hqm.message.hasLivesRemaining", playerName, lives);
    }
}

