/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import hardcorequesting.common.forge.commands.sub.EditSubCommand;
import hardcorequesting.common.forge.commands.sub.EnableSubCommand;
import hardcorequesting.common.forge.commands.sub.HardcoreSubCommand;
import hardcorequesting.common.forge.commands.sub.HelpSubCommand;
import hardcorequesting.common.forge.commands.sub.LivesSubCommand;
import hardcorequesting.common.forge.commands.sub.OpSubCommand;
import hardcorequesting.common.forge.commands.sub.QuestSubCommand;
import hardcorequesting.common.forge.commands.sub.VersionSubCommand;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.util.Translator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CommandHandler {
    public static final Map<String, SubCommand> SUB_COMMANDS = new HashMap<String, SubCommand>();

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"hqm");
        for (String s : SUB_COMMANDS.keySet()) {
            builder = (LiteralArgumentBuilder)builder.then(SUB_COMMANDS.get(s).build((LiteralArgumentBuilder<CommandSource>)Commands.func_197057_a((String)s)));
        }
        dispatcher.register((LiteralArgumentBuilder)builder.executes(context -> 1));
    }

    static {
        SUB_COMMANDS.put("help", new HelpSubCommand());
        SUB_COMMANDS.put("hardcore", new HardcoreSubCommand());
        SUB_COMMANDS.put("lives", new LivesSubCommand());
        SUB_COMMANDS.put("op", new OpSubCommand());
        SUB_COMMANDS.put("edit", new EditSubCommand());
        SUB_COMMANDS.put("quest", new QuestSubCommand());
        SUB_COMMANDS.put("enable", new EnableSubCommand());
        SUB_COMMANDS.put("version", new VersionSubCommand());
    }

    public static interface SubCommand {
        public ArgumentBuilder<CommandSource, ?> build(LiteralArgumentBuilder<CommandSource> var1);

        default public int[] getSyntaxOptions(CommandContext<CommandSource> context) {
            return new int[0];
        }

        default public void currentLives(PlayerEntity player) {
            player.func_195051_bN().func_197030_a((ITextComponent)new StringTextComponent("You currently have " + QuestingDataManager.getInstance().getQuestingData(player).getLives() + " live(s) left."), false);
        }

        default public void currentLives(CommandSource source, PlayerEntity player) {
            source.func_197030_a((ITextComponent)new StringTextComponent(player.func_195047_I_() + " currently has " + QuestingDataManager.getInstance().getQuestingData(player).getLives() + " live(s) left."), false);
        }

        default public void sendChat(CommandSource sender, ITextComponent text) {
            sender.func_197030_a(text, false);
        }

        default public void sendTranslatableChat(CommandSource sender, String key, Object ... args) {
            sender.func_197030_a((ITextComponent)Translator.translatable(key, args), false);
        }

        default public void sendTranslatableChat(CommandSource sender, boolean plural, String key, Object ... args) {
            sender.func_197030_a((ITextComponent)Translator.pluralTranslated(plural, key, args), false);
        }
    }
}

