/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.sounds;

import hardcorequesting.common.forge.client.ClientChange;
import hardcorequesting.common.forge.client.sounds.ClientSound;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoundHandler {
    private static final String LABEL = "lore";
    private static List<String> paths = new ArrayList<String>();
    private static int loreNumber;
    private static boolean loreMusic;
    @OnlyIn(value=Dist.CLIENT)
    private static ISound loreSound;

    private SoundHandler() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean loadLoreReading(Path path) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playLoreMusic() {
        loreSound = SoundHandler.play(LABEL + loreNumber, 4.0f, 1.0f);
    }

    public static void play(Sounds sound, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkManager.sendToPlayer(ClientChange.SOUND.build((Object)sound), (ServerPlayerEntity)player);
        }
    }

    public static void playToAll(Sounds sound) {
        NetworkManager.sendToAllPlayers(ClientChange.SOUND.build((Object)sound));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static ISound play(String sound, float volume, float pitch) {
        return SoundHandler.play(new ResourceLocation("hardcorequesting", sound), volume, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static ISound play(ResourceLocation resource, float volume, float pitch) {
        ClientSound soundObj = new ClientSound(resource, volume, pitch);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)soundObj);
        return soundObj;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void stopLoreMusic() {
        if (SoundHandler.isLorePlaying()) {
            new Thread(() -> {
                while (SoundHandler.isLorePlaying()) {
                    Minecraft.func_71410_x().func_147118_V().func_147683_b(loreSound);
                }
                loreSound = null;
            }).start();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isLorePlaying() {
        boolean value;
        boolean bl = value = loreSound != null && Minecraft.func_71410_x().func_147118_V().func_215294_c(loreSound);
        if (!value) {
            loreSound = null;
        }
        return value;
    }

    public static boolean hasLoreMusic() {
        return loreMusic;
    }

    public static void handleSoundPacket(Sounds sound) {
        SoundHandler.play(sound.getSoundId(), 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void triggerFirstLore() {
        NetworkManager.sendToServer(ClientChange.LORE.build(null));
        SoundHandler.playLoreMusic();
    }

    public static void handleLorePacket(PlayerEntity player) {
        QuestingDataManager.getInstance().getQuestingData((PlayerEntity)player).playedLore = true;
    }

    static {
        loreMusic = false;
    }
}

