/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.LargeButton;
import hardcorequesting.common.forge.client.interfaces.TextBoxLogic;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextMenu
extends GuiEditMenu {
    private static final int TEXT_HEIGHT = 9;
    private static final int START_X = 20;
    private static final int START_Y = 20;
    private static final int LINES_PER_PAGE = 21;
    private final Consumer<String> resultConsumer;
    private final int limit;
    protected TextBoxLogic text;
    private final boolean isName;

    public static void display(GuiQuestBook gui, PlayerEntity player, String txt, boolean isName, Consumer<String> resultConsumer) {
        gui.setEditMenu(new TextMenu(gui, player, txt, isName, -1, resultConsumer));
    }

    public static void display(GuiQuestBook gui, PlayerEntity player, String txt, int limit, Consumer<String> resultConsumer) {
        gui.setEditMenu(new TextMenu(gui, player, txt, true, limit, resultConsumer));
    }

    protected TextMenu(GuiQuestBook gui, PlayerEntity player, String txt, boolean isName, int limit, Consumer<String> resultConsumer) {
        super(gui, player, false);
        this.resultConsumer = resultConsumer;
        this.limit = limit;
        if (txt != null && !txt.isEmpty()) {
            txt = txt.replace("\n", "\\n");
        }
        this.text = new TextBoxLogic(gui, txt, 140, true);
        this.isName = isName;
        this.buttons.add(new LargeButton("hqm.textEditor.copyAll", 185, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                Minecraft.func_71410_x().field_195559_v.func_197960_a(TextMenu.this.text.getText());
            }
        });
        this.buttons.add(new LargeButton("hqm.textEditor.paste", 245, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                String clip = Minecraft.func_71410_x().field_195559_v.func_197965_a();
                if (!clip.isEmpty()) {
                    clip = clip.replace("\n", "\\n");
                }
                TextMenu.this.text.addText(gui, clip);
            }
        });
        this.buttons.add(new LargeButton("hqm.textEditor.clear", 185, 40){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                TextMenu.this.text.setTextAndCursor(gui, "");
            }
        });
        this.buttons.add(new LargeButton("hqm.textEditor.clearPaste", 245, 40){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                String clip = Minecraft.func_71410_x().field_195559_v.func_197965_a();
                if (!clip.isEmpty()) {
                    clip = clip.replace("\n", "\\n");
                }
                TextMenu.this.text.setTextAndCursor(gui, clip);
            }
        });
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.draw(matrices, gui, mX, mY);
        int page = this.text.getCursorLine(gui) / 21;
        gui.drawString(matrices, this.text.getLines().stream().map(ITextProperties::func_240652_a_).collect(Collectors.toList()), page * 21, 21, 20, 20, 1.0f, 0x404040);
        gui.drawCursor(matrices, 20 + this.text.getCursorPositionX(gui) - 1, 20 + this.text.getCursorPositionY(gui) - 3 - page * 21 * 9, 10, 1.0f, -7303024);
    }

    @Override
    public void onKeyStroke(GuiBase gui, char c, int k) {
        super.onKeyStroke(gui, c, k);
        this.text.onKeyStroke(gui, c, k);
    }

    @Override
    public void save(GuiBase gui) {
        String str = this.text.getText();
        if (str == null || str.isEmpty()) {
            str = I18n.func_135052_a((String)"hqm.textEditor.unnamed", (Object[])new Object[0]);
        }
        if (!this.isName) {
            str = str.replace("\\n", "\n");
        }
        if (this.limit >= 0) {
            while (gui.getStringWidth(str) > this.limit) {
                str = str.substring(0, str.length() - 1);
            }
        }
        this.resultConsumer.accept(str);
        if (this.isName) {
            SaveHelper.add(EditType.NAME_CHANGE);
        } else {
            SaveHelper.add(EditType.DESCRIPTION_CHANGE);
        }
    }
}

