/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.TextBoxGroup;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.common.forge.quests.task.icon.TameMobsTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextProperties;

public class PickMobMenu
extends GuiEditMenuExtended {
    public static final List<Entry> EXTRA_TAME_ENTRIES = ImmutableList.of((Object)new Entry(TameMobsTask.ABSTRACT_HORSE, Translator.plain("Any Horse-like Entity")));
    private static final int START_X = 20;
    private static final int START_Y = 20;
    private static final int OFFSET_Y = 8;
    private static final int VISIBLE_MOBS = 24;
    private final Consumer<Result> resultConsumer;
    private final String textKey;
    private Entry mob;
    private int amount;
    private final ScrollBar scrollBar;
    private final List<Entry> rawMobs;
    private final List<Entry> mobs;

    public static void display(GuiQuestBook gui, PlayerEntity player, ResourceLocation initMobId, int initAmount, String textKey, Consumer<Result> resultConsumer) {
        gui.setEditMenu(new PickMobMenu(gui, player, initMobId, initAmount, textKey, Collections.emptyList(), resultConsumer));
    }

    public static void display(GuiQuestBook gui, PlayerEntity player, ResourceLocation initMobId, int initAmount, String textKey, List<Entry> extraEntries, Consumer<Result> resultConsumer) {
        gui.setEditMenu(new PickMobMenu(gui, player, initMobId, initAmount, textKey, extraEntries, resultConsumer));
    }

    private PickMobMenu(GuiQuestBook gui, PlayerEntity player, ResourceLocation initMobId, int initAmount, String textKey, List<Entry> extraEntries, Consumer<Result> resultConsumer) {
        super(gui, player, false, 180, 70, 180, 150);
        this.resultConsumer = resultConsumer;
        this.textKey = textKey;
        this.amount = initAmount;
        this.scrollBar = new ScrollBar(160, 18, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return PickMobMenu.this.mobs.size() > 24;
            }
        };
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber((GuiBase)gui, 0, "hqm." + textKey + ".reqKills"){

            @Override
            protected int getValue() {
                return PickMobMenu.this.amount;
            }

            @Override
            protected void setValue(int number) {
                PickMobMenu.this.amount = number;
            }
        });
        this.textBoxes.add(new TextBoxGroup.TextBox(gui, "", 250, 18, false){

            @Override
            public void textChanged(GuiBase gui) {
                super.textChanged(gui);
                PickMobMenu.this.updateMobs(this.getText());
            }
        });
        this.rawMobs = new ArrayList<Entry>();
        this.mobs = new ArrayList<Entry>();
        for (EntityType type : Registry.field_212629_r) {
            if (!type.func_200720_b()) continue;
            this.rawMobs.add(new Entry(type));
        }
        this.rawMobs.addAll(extraEntries);
        for (Entry entry2 : this.rawMobs) {
            if (!entry2.id.equals((Object)initMobId)) continue;
            this.mob = entry2;
        }
        this.rawMobs.sort(Comparator.comparing(entry -> ((Entry)entry).id));
        this.updateMobs("");
    }

    private void updateMobs(String search) {
        search = search.toLowerCase();
        if (this.mobs != null) {
            this.mobs.clear();
            for (Entry rawMob : this.rawMobs) {
                if (!rawMob.description.toString().toLowerCase().contains(search) && !rawMob.id.toString().toLowerCase().contains(search)) continue;
                this.mobs.add(rawMob);
            }
        }
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.draw(matrices, gui, mX, mY);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.scrollBar.draw(gui);
        int start = this.scrollBar.isVisible(gui) ? Math.round((float)(this.mobs.size() - 24) * this.scrollBar.getScroll()) : 0;
        int end = Math.min(this.mobs.size(), start + 24);
        for (int i = start; i < end; ++i) {
            boolean selected = this.mobs.get(i).equals(this.mob);
            boolean inBounds = gui.inBounds(20, 20 + (i - start) * 8, 130, 6, mX, mY);
            gui.drawString(matrices, this.mobs.get(i).description, 20, 20 + 8 * (i - start), 0.7f, selected ? (inBounds ? 0xC0C0C0 : 0xA0A0A0) : (inBounds ? 0x707070 : 0x404040));
        }
        gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm." + this.textKey + ".search", new Object[0]), 180, 20, 0x404040);
        gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm." + this.textKey + "." + (this.mob == null ? "nothing" : "currently") + "Selected", new Object[0]), 180, 40, 0x404040);
        if (this.mob != null) {
            gui.drawString(matrices, this.mob.description, 180, 50, 0.7f, 0x404040);
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        this.scrollBar.onClick(gui, mX, mY);
        int start = this.scrollBar.isVisible(gui) ? Math.round((float)(this.mobs.size() - 24) * this.scrollBar.getScroll()) : 0;
        int end = Math.min(this.mobs.size(), start + 24);
        for (int i = start; i < end; ++i) {
            if (!gui.inBounds(20, 20 + (i - start) * 8, 130, 6, mX, mY)) continue;
            if (this.mobs.get(i).equals(this.mob)) {
                this.mob = null;
                break;
            }
            this.mob = this.mobs.get(i);
            break;
        }
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        this.scrollBar.onRelease(gui, mX, mY);
    }

    @Override
    protected boolean isArrowVisible() {
        return false;
    }

    @Override
    protected void onArrowClick(boolean left) {
    }

    @Override
    protected String getArrowText() {
        return I18n.func_135052_a((String)("hqm." + this.textKey + ".typeMatch.title"), (Object[])new Object[0]);
    }

    @Override
    protected String getArrowDescription() {
        return I18n.func_135052_a((String)("hqm." + this.textKey + ".typeMatch.desc"), (Object[])new Object[0]);
    }

    @Override
    public void onDrag(GuiBase gui, int mX, int mY) {
        super.onDrag(gui, mX, mY);
        this.scrollBar.onDrag(gui, mX, mY);
    }

    @Override
    public void onScroll(GuiBase gui, double mX, double mY, double scroll) {
        super.onScroll(gui, mX, mY, scroll);
        this.scrollBar.onScroll(gui, mX, mY, scroll);
    }

    @Override
    public void save(GuiBase gui) {
        this.resultConsumer.accept(new Result(this.mob.id, Math.max(1, this.amount)));
    }

    public static class Entry {
        private final ResourceLocation id;
        private final ITextProperties description;

        private Entry(EntityType<?> type) {
            this.id = Registry.field_212629_r.func_177774_c(type);
            this.description = type.func_212546_e();
        }

        public Entry(ResourceLocation id, ITextProperties description) {
            this.id = id;
            this.description = description;
        }
    }

    public static class Result {
        private final ResourceLocation mobId;
        private final int amount;

        private Result(ResourceLocation mobId, int amount) {
            this.mobId = mobId;
            this.amount = amount;
        }

        public ResourceLocation getMobId() {
            return this.mobId;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

