/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.TextSearch;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.TextBoxGroup;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.platform.FluidStack;
import hardcorequesting.common.forge.quests.ItemPrecision;
import hardcorequesting.common.forge.util.Fraction;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PickItemMenu<T>
extends GuiEditMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ARROW_X_LEFT = 20;
    private static final int ARROW_X_RIGHT = 150;
    private static final int ARROW_Y = 40;
    private static final int ARROW_SRC_X = 244;
    private static final int ARROW_SRC_Y = 176;
    private static final int ARROW_W = 6;
    private static final int ARROW_H = 10;
    private static final int PLAYER_X = 20;
    private static final int PLAYER_Y = 80;
    private static final int SEARCH_X = 180;
    private static final int SEARCH_Y = 30;
    private static final int SIZE = 18;
    private static final int OFFSET = 20;
    private static final int ITEMS_PER_LINE = 7;
    private static final int SEARCH_LINES = 9;
    public static final int ITEMS_TO_DISPLAY = 63;
    private static final int PLAYER_LINES = 6;
    private final Consumer<Result<T>> resultConsumer;
    private final boolean precisionInput;
    private final Type<T> type;
    private final List<T> playerItems;
    private List<T> searchItems;
    private Future<List<T>> search;
    private T selected;
    private int amount;
    private ItemPrecision precision;
    private boolean clicked;
    private TextBoxGroup.TextBox amountTextBox;
    private TextBoxGroup textBoxes;
    private int lastClicked;

    public static <T> void display(GuiBase gui, PlayerEntity player, T initial, Type<T> type, Consumer<Result<T>> resultConsumer) {
        gui.setEditMenu(new PickItemMenu<T>(gui, player, initial, type, 1, false, ItemPrecision.PRECISE, false, resultConsumer));
    }

    public static <T> void display(GuiBase gui, PlayerEntity player, T obj, Type<T> type, int amount, Consumer<Result<T>> resultConsumer) {
        gui.setEditMenu(new PickItemMenu<T>(gui, player, obj, type, amount, true, ItemPrecision.PRECISE, false, resultConsumer));
    }

    public static <T> void display(GuiBase gui, PlayerEntity player, T obj, Type<T> type, int amount, ItemPrecision precision, Consumer<Result<T>> resultConsumer) {
        gui.setEditMenu(new PickItemMenu<T>(gui, player, obj, type, amount, true, precision, true, resultConsumer));
    }

    private PickItemMenu(GuiBase gui, PlayerEntity player, T element, Type<T> type, int amount, boolean amountInput, ItemPrecision precision, boolean precisionInput, Consumer<Result<T>> resultConsumer) {
        super(gui, player, true);
        this.resultConsumer = resultConsumer;
        this.type = type;
        this.precisionInput = precisionInput;
        this.selected = type.copyWith(element, 1);
        this.amount = amount;
        this.precision = precision;
        this.searchItems = Collections.emptyList();
        this.playerItems = type.createPlayerEntries(player);
        this.textBoxes = new TextBoxGroup();
        if (amountInput) {
            this.amountTextBox = new TextBoxGroup.TextBox(gui, String.valueOf(amount), 100, 18, false){

                @Override
                protected boolean isCharacterValid(char c, String rest) {
                    return Character.isDigit(c);
                }

                @Override
                public void textChanged(GuiBase gui) {
                    try {
                        int number = this.getText().equals("") ? 1 : Integer.parseInt(this.getText());
                        if (number == 0) {
                            number = 1;
                        }
                        PickItemMenu.this.amount = number;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.textBoxes.add(this.amountTextBox);
        }
        this.textBoxes.add(new TextBoxGroup.TextBox(gui, "", 230, 18, false){

            @Override
            public void textChanged(GuiBase gui) {
                PickItemMenu.this.startSearch(this.getText());
            }
        });
    }

    private boolean inArrowBounds(GuiBase gui, int mX, int mY, boolean left) {
        return gui.inBounds(left ? 20 : 150, 40, 6, 10, mX, mY);
    }

    private void drawArrow(GuiBase gui, int mX, int mY, boolean left) {
        int srcX = 244 + (left ? 0 : 6);
        int srcY = 176 + (this.inArrowBounds(gui, mX, mY, left) ? (this.clicked ? 1 : 2) : 0) * 10;
        gui.drawRect(left ? 20 : 150, 40, srcX, srcY, 6, 10);
    }

    private boolean usePrecision() {
        return this.precisionInput && this.type.mayHavePrecision(this.selected);
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        this.checkSearchResult();
        super.draw(matrices, gui, mX, mY);
        gui.drawString(matrices, Translator.plain("Selected"), 20, 20, 0x404040);
        this.type.draw(this.selected, matrices, gui, 70, 15, mX, mY);
        gui.drawString(matrices, Translator.plain("Search"), 180, 20, 0x404040);
        this.drawList(matrices, gui, 180, 30, this.searchItems, mX, mY);
        gui.drawString(matrices, Translator.plain("Player inventory"), 20, 70, 0x404040);
        this.drawList(matrices, gui, 20, 80, this.playerItems, mX, mY);
        this.textBoxes.draw(matrices, gui);
        if (this.usePrecision()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            this.drawArrow(gui, mX, mY, true);
            this.drawArrow(gui, mX, mY, false);
            gui.drawCenteredString(matrices, Translator.plain(this.precision.getName()), 26, 40, 0.7f, 124, 10, 0x404040);
        }
    }

    @Override
    public void renderTooltip(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.renderTooltip(matrices, gui, mX, mY);
        this.drawListMouseOver(matrices, gui, 180, 30, this.searchItems, mX, mY);
        this.drawListMouseOver(matrices, gui, 20, 80, this.playerItems, mX, mY);
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        if (this.clickList(gui, 20, 80, this.playerItems, mX, mY)) {
            return;
        }
        if (this.clickList(gui, 180, 30, this.searchItems, mX, mY)) {
            return;
        }
        this.textBoxes.onClick(gui, mX, mY);
        if (this.usePrecision()) {
            if (this.inArrowBounds(gui, mX, mY, true)) {
                ImmutableList<ItemPrecision> precisionTypes = ItemPrecision.getPrecisionTypes();
                this.precision = (ItemPrecision)precisionTypes.get((precisionTypes.indexOf(this.precision) + precisionTypes.size() - 1) % precisionTypes.size());
                this.clicked = true;
            } else if (this.inArrowBounds(gui, mX, mY, false)) {
                ImmutableList<ItemPrecision> precisionTypes = ItemPrecision.getPrecisionTypes();
                this.precision = (ItemPrecision)precisionTypes.get((precisionTypes.indexOf(this.precision) + 1) % precisionTypes.size());
                this.clicked = true;
            }
        }
    }

    @Override
    public void onKeyStroke(GuiBase gui, char c, int k) {
        super.onKeyStroke(gui, c, k);
        this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        this.clicked = false;
    }

    @Override
    public void save(GuiBase gui) {
        if (!this.type.isEmpty(this.selected)) {
            this.resultConsumer.accept(new Result(this.selected, this.amount, this.precision, this.type));
        }
    }

    private void drawList(MatrixStack matrices, GuiBase gui, int x, int y, List<T> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            T element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            this.type.draw(element, matrices, gui, x + xI * 20, y + yI * 20, mX, mY);
        }
    }

    private void drawListMouseOver(MatrixStack matrices, GuiBase gui, int x, int y, List<T> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            T element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            if (!gui.inBounds(x + xI * 20, y + yI * 20, 18, 18, mX, mY)) continue;
            if (element == null) break;
            gui.renderTooltipL(matrices, this.type.getName(element, gui), mX + gui.getLeft(), mY + gui.getTop());
            break;
        }
    }

    private boolean clickList(GuiBase gui, int x, int y, List<T> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            T element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            if (!gui.inBounds(x + xI * 20, y + yI * 20, 18, 18, mX, mY)) continue;
            if (element == null) break;
            this.selected = element;
            int lastDiff = this.player.field_70173_aa - this.lastClicked;
            if (0 <= lastDiff && lastDiff < 6 && !this.type.isEmpty(this.selected)) {
                this.save(gui);
                this.close(gui);
                return true;
            }
            this.lastClicked = this.player.field_70173_aa;
            break;
        }
        return false;
    }

    private static List<ItemStack> getPlayerItems(PlayerEntity player) {
        ArrayList<ItemStack> playerItems = new ArrayList<ItemStack>();
        PlayerInventory inventory = player.field_71071_by;
        int itemLength = inventory.func_70302_i_();
        for (int i = 0; i < itemLength; ++i) {
            ItemStack invStack = inventory.func_70301_a(i);
            if (invStack.func_190926_b() || invStack.func_77973_b() == ModItems.book.get()) continue;
            ItemStack stack = invStack.func_77946_l();
            stack.func_190920_e(1);
            if (!playerItems.stream().noneMatch(other -> ItemStack.func_77989_b((ItemStack)stack, (ItemStack)other))) continue;
            playerItems.add(stack);
        }
        return playerItems;
    }

    private static List<FluidStack> getPlayerFluids(PlayerEntity player) {
        ArrayList<FluidStack> playerFluids = new ArrayList<FluidStack>();
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        PlayerInventory inventory = player.field_71071_by;
        int itemLength = inventory.func_70302_i_();
        for (int i = 0; i < itemLength; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            FluidStack fluid = HardcoreQuestingCore.platform.findFluidIn(stack);
            if (fluid.isEmpty() || !fluids.add(fluid.getFluid())) continue;
            playerFluids.add(fluid);
        }
        return playerFluids;
    }

    private void startSearch(String text) {
        this.searchItems.clear();
        this.search = TextSearch.startSearch(text, this.type::getSearchEntriesStream, 63);
    }

    private void checkSearchResult() {
        if (this.search != null && this.search.isDone()) {
            if (this.search.isCancelled()) {
                LOGGER.error("Item search had been cancelled, but the reference was kept!");
                this.search = null;
            } else {
                try {
                    this.searchItems = this.search.get();
                    this.search = null;
                }
                catch (ExecutionException e) {
                    LOGGER.error("Item search failed with error: ", e.getCause());
                    this.search = null;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static class Result<T> {
        private final T value;
        private final int amount;
        private final ItemPrecision precision;
        private final Type<T> type;

        private Result(T value, int amount, ItemPrecision precision, Type<T> type) {
            this.value = value;
            this.amount = amount;
            this.precision = precision;
            this.type = type;
        }

        public T get() {
            return this.type.copyWith(this.value, 1);
        }

        public T getWithAmount() {
            return this.type.copyWith(this.value, this.amount);
        }

        public int getAmount() {
            return this.amount;
        }

        public ItemPrecision getPrecision() {
            return this.precision;
        }
    }

    public static abstract class Type<T> {
        public static final Type<ItemStack> ITEM = new Type<ItemStack>(){

            @Override
            protected List<ItemStack> createPlayerEntries(PlayerEntity player) {
                return PickItemMenu.getPlayerItems(player);
            }

            @Override
            protected Stream<TextSearch.SearchEntry<ItemStack>> getSearchEntriesStream() {
                return TextSearch.ITEMS.stream();
            }

            @Override
            protected void draw(ItemStack item, MatrixStack matrices, GuiBase gui, int x, int y, int mX, int mY) {
                gui.drawItemStack(item, x, y, mX, mY, false);
            }

            @Override
            protected List<ITextComponent> getName(ItemStack item, GuiBase gui) {
                return gui.func_231151_a_(item);
            }

            @Override
            protected boolean isEmpty(ItemStack item) {
                return item.func_190926_b();
            }

            @Override
            protected boolean mayHavePrecision(ItemStack item) {
                return true;
            }

            @Override
            protected ItemStack copyWith(ItemStack item, int amount) {
                ItemStack newStack = item.func_77946_l();
                newStack.func_190920_e(MathHelper.func_76125_a((int)amount, (int)1, (int)127));
                return newStack;
            }
        };
        public static final Type<Either<ItemStack, FluidStack>> ITEM_FLUID = new Type<Either<ItemStack, FluidStack>>(){

            @Override
            protected List<Either<ItemStack, FluidStack>> createPlayerEntries(PlayerEntity player) {
                return Stream.concat(PickItemMenu.getPlayerItems(player).stream().map(Either::left), PickItemMenu.getPlayerFluids(player).stream().map(Either::right)).limit(42L).collect(Collectors.toList());
            }

            @Override
            protected Stream<TextSearch.SearchEntry<Either<ItemStack, FluidStack>>> getSearchEntriesStream() {
                return Stream.concat(TextSearch.innerMap(TextSearch.ITEMS.stream(), Either::left), TextSearch.innerMap(TextSearch.FLUIDS.stream(), Either::right));
            }

            @Override
            protected void draw(Either<ItemStack, FluidStack> item, MatrixStack matrices, GuiBase gui, int x, int y, int mX, int mY) {
                item.ifLeft(stack -> gui.drawItemStack((ItemStack)stack, x, y, mX, mY, false)).ifRight(stack -> gui.drawFluid((FluidStack)stack, matrices, x, y, mX, mY));
            }

            @Override
            protected List<ITextComponent> getName(Either<ItemStack, FluidStack> item, GuiBase gui) {
                return (List)item.map(arg_0 -> ((GuiBase)gui).func_231151_a_(arg_0), stack -> Collections.singletonList(stack.getName()));
            }

            @Override
            protected boolean isEmpty(Either<ItemStack, FluidStack> item) {
                return (Boolean)item.map(ItemStack::func_190926_b, FluidStack::isEmpty);
            }

            @Override
            protected boolean mayHavePrecision(Either<ItemStack, FluidStack> item) {
                return item.left().isPresent();
            }

            @Override
            protected Either<ItemStack, FluidStack> copyWith(Either<ItemStack, FluidStack> item, int amount) {
                return item.mapBoth(stack -> {
                    ItemStack newStack = stack.func_77946_l();
                    newStack.func_190920_e(amount);
                    return newStack;
                }, stack -> HardcoreQuestingCore.platform.createFluidStack(stack.getFluid(), Fraction.ofWhole(amount)));
            }
        };

        protected abstract List<T> createPlayerEntries(PlayerEntity var1);

        protected abstract Stream<TextSearch.SearchEntry<T>> getSearchEntriesStream();

        protected abstract void draw(T var1, MatrixStack var2, GuiBase var3, int var4, int var5, int var6, int var7);

        protected abstract List<? extends ITextProperties> getName(T var1, GuiBase var2);

        protected abstract boolean isEmpty(T var1);

        protected abstract boolean mayHavePrecision(T var1);

        protected abstract T copyWith(T var1, int var2);
    }
}

