/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.TextBoxGroup;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;

public class PickAdvancementMenu
extends GuiEditMenuExtended {
    private static final int START_X = 20;
    private static final int START_Y = 20;
    private static final int OFFSET_Y = 8;
    private static final int VISIBLE_MOBS = 24;
    private final Consumer<String> resultConsumer;
    private String advancement;
    private ScrollBar scrollBar;
    private List<String> rawAdvancemenNames;
    private List<String> advancementNames;

    public static void display(GuiQuestBook gui, PlayerEntity player, String advancement, Consumer<String> resultConsumer) {
        gui.setEditMenu(new PickAdvancementMenu(gui, player, advancement, resultConsumer));
    }

    private PickAdvancementMenu(GuiQuestBook gui, PlayerEntity player, String advancement, Consumer<String> resultConsumer) {
        super(gui, player, false, 180, 70, 180, 150);
        this.resultConsumer = resultConsumer;
        this.advancement = advancement;
        this.scrollBar = new ScrollBar(160, 18, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return PickAdvancementMenu.this.advancementNames.size() > 24;
            }
        };
        this.textBoxes.add(new TextBoxGroup.TextBox(gui, "", 250, 18, false){

            @Override
            public void textChanged(GuiBase gui) {
                super.textChanged(gui);
                PickAdvancementMenu.this.updateAdvancements(this.getText());
            }
        });
        this.rawAdvancemenNames = new ArrayList<String>();
        this.advancementNames = new ArrayList<String>();
        for (Advancement a : HardcoreQuestingCore.getServer().func_191949_aK().func_195438_b()) {
            String adv = a.func_192067_g().toString();
            this.rawAdvancemenNames.add(adv);
            this.advancementNames.add(adv);
        }
        Collections.sort(this.advancementNames);
        this.updateAdvancements("");
    }

    private void updateAdvancements(String search) {
        if (this.advancementNames != null) {
            this.advancementNames.clear();
            for (String rawAdv : this.rawAdvancemenNames) {
                if (!rawAdv.toLowerCase().contains(search.toLowerCase())) continue;
                this.advancementNames.add(rawAdv);
            }
            Collections.sort(this.advancementNames);
        }
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.draw(matrices, gui, mX, mY);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.scrollBar.draw(gui);
        int start = this.scrollBar.isVisible(gui) ? Math.round((float)(this.advancementNames.size() - 24) * this.scrollBar.getScroll()) : 0;
        int end = Math.min(this.advancementNames.size(), start + 24);
        for (int i = start; i < end; ++i) {
            boolean selected = this.advancementNames.get(i).equals(this.advancement);
            boolean inBounds = gui.inBounds(20, 20 + (i - start) * 8, 130, 6, mX, mY);
            gui.drawString(matrices, Translator.plain(this.advancementNames.get(i)), 20, 20 + 8 * (i - start), 0.7f, selected ? (inBounds ? 0xC0C0C0 : 0xA0A0A0) : (inBounds ? 0x707070 : 0x404040));
        }
        gui.drawString(matrices, Translator.plain("Search"), 180, 20, 0x404040);
        gui.drawString(matrices, Translator.plain((this.advancement == null ? "Nothing" : "Currently") + "Selected"), 180, 40, 0x404040);
        if (this.advancement != null) {
            gui.drawString(matrices, Translator.plain(this.advancement), 180, 50, 0.7f, 0x404040);
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        this.scrollBar.onClick(gui, mX, mY);
        int start = this.scrollBar.isVisible(gui) ? Math.round((float)(this.advancementNames.size() - 24) * this.scrollBar.getScroll()) : 0;
        int end = Math.min(this.advancementNames.size(), start + 24);
        for (int i = start; i < end; ++i) {
            if (!gui.inBounds(20, 20 + (i - start) * 8, 130, 6, mX, mY)) continue;
            if (this.advancementNames.get(i).equals(this.advancement)) {
                this.advancement = null;
                break;
            }
            this.advancement = this.advancementNames.get(i);
            break;
        }
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        this.scrollBar.onRelease(gui, mX, mY);
    }

    @Override
    protected void onArrowClick(boolean left) {
    }

    @Override
    protected String getArrowText() {
        return "Exact Advancement";
    }

    @Override
    protected String getArrowDescription() {
        return "Completing the exact advancement is required.";
    }

    @Override
    public void onDrag(GuiBase gui, int mX, int mY) {
        super.onDrag(gui, mX, mY);
        this.scrollBar.onDrag(gui, mX, mY);
    }

    @Override
    public void onScroll(GuiBase gui, double mX, double mY, double scroll) {
        super.onScroll(gui, mX, mY, scroll);
        this.scrollBar.onScroll(gui, mX, mY, scroll);
    }

    @Override
    public void save(GuiBase gui) {
        this.resultConsumer.accept(this.advancement);
    }
}

