/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.LargeButton;
import hardcorequesting.common.forge.client.interfaces.TextBoxGroup;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.common.forge.quests.task.icon.VisitLocationTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextProperties;

public class LocationMenu
extends GuiEditMenuExtended {
    private final Consumer<Result> resultConsumer;
    private VisitLocationTask.Visibility visibility;
    private BlockPos.Mutable pos;
    private int radius;
    private String dimension;

    public static void display(GuiQuestBook gui, PlayerEntity player, VisitLocationTask.Visibility visibility, BlockPos initPos, int initRadius, String initDimension, Consumer<Result> resultConsumer) {
        gui.setEditMenu(new LocationMenu(gui, player, visibility, initPos, initRadius, initDimension, resultConsumer));
    }

    private LocationMenu(GuiQuestBook gui, PlayerEntity player, VisitLocationTask.Visibility visibility, BlockPos initPos, int initRadius, String initDimension, Consumer<Result> resultConsumer) {
        super(gui, player, true, 180, 30, 20, 30);
        this.resultConsumer = resultConsumer;
        this.visibility = visibility;
        this.pos = new BlockPos.Mutable(initPos.func_177958_n(), initPos.func_177956_o(), initPos.func_177952_p());
        this.radius = initRadius;
        this.dimension = initDimension;
        this.textBoxes.add(new TextBoxNumberNegative(gui, 0, "hqm.locationMenu.xTarget"){

            @Override
            protected void setValue(int number) {
                LocationMenu.this.pos.func_223471_o(number);
            }

            @Override
            protected int getValue() {
                return LocationMenu.this.pos.func_177958_n();
            }
        });
        this.textBoxes.add(new TextBoxNumberNegative(gui, 1, "hqm.locationMenu.yTarget"){

            @Override
            protected void setValue(int number) {
                LocationMenu.this.pos.func_185336_p(number);
            }

            @Override
            protected int getValue() {
                return LocationMenu.this.pos.func_177956_o();
            }
        });
        this.textBoxes.add(new TextBoxNumberNegative(gui, 2, "hqm.locationMenu.zTarget"){

            @Override
            protected void setValue(int number) {
                LocationMenu.this.pos.func_223472_q(number);
            }

            @Override
            protected int getValue() {
                return LocationMenu.this.pos.func_177952_p();
            }
        });
        TextBoxGroup.TextBox locationBox = new TextBoxGroup.TextBox(gui, initDimension, this.BOX_X, this.BOX_Y + 90, true){

            @Override
            public void textChanged(GuiBase gui) {
                super.textChanged(gui);
                LocationMenu.this.dimension = this.getText();
            }

            @Override
            protected void draw(MatrixStack matrices, GuiBase gui, boolean selected) {
                super.draw(matrices, gui, selected);
                gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.locationMenu.dim", new Object[0]), LocationMenu.this.BOX_X, LocationMenu.this.BOX_Y + 90 + -10, 0x404040);
            }
        };
        this.textBoxes.add(locationBox);
        locationBox.recalculateCursor(gui);
        this.textBoxes.add(new TextBoxNumberNegative(gui, 4, "hqm.locationMenu.radius"){

            @Override
            protected int getValue() {
                return LocationMenu.this.radius;
            }

            @Override
            protected void setValue(int number) {
                LocationMenu.this.radius = number;
            }

            @Override
            protected void draw(MatrixStack matrices, GuiBase gui, boolean selected) {
                super.draw(matrices, gui, selected);
                gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.locationMenu.negRadius", new Object[0]), 0.7f, 130), LocationMenu.this.BOX_X, LocationMenu.this.BOX_Y + 150 + -10, 0.7f, 0x404040);
            }
        });
        this.buttons.add(new LargeButton("hqm.locationMenu.location", 100, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                LocationMenu.this.pos = new BlockPos.Mutable(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                LocationMenu.this.dimension = player.field_70170_p.func_234923_W_().func_240901_a_().toString();
                for (TextBoxGroup.TextBox textBox : LocationMenu.this.textBoxes.getTextBoxes()) {
                    if (textBox instanceof GuiEditMenuExtended.TextBoxNumber) {
                        textBox.setTextAndCursor(gui, String.valueOf(((GuiEditMenuExtended.TextBoxNumber)textBox).getValue()));
                        continue;
                    }
                    textBox.recalculateCursor(gui);
                }
            }
        });
    }

    @Override
    protected void onArrowClick(boolean left) {
        this.visibility = left ? VisitLocationTask.Visibility.values()[(this.visibility.ordinal() + VisitLocationTask.Visibility.values().length - 1) % VisitLocationTask.Visibility.values().length] : VisitLocationTask.Visibility.values()[(this.visibility.ordinal() + 1) % VisitLocationTask.Visibility.values().length];
    }

    @Override
    protected String getArrowText() {
        return this.visibility.getName();
    }

    @Override
    protected String getArrowDescription() {
        return this.visibility.getDescription();
    }

    @Override
    public void save(GuiBase gui) {
        this.resultConsumer.accept(new Result(this.visibility, this.pos.func_185334_h(), this.radius, this.dimension));
    }

    public static class Result {
        private final VisitLocationTask.Visibility visibility;
        private final BlockPos pos;
        private final int radius;
        private final String dimension;

        private Result(VisitLocationTask.Visibility visibility, BlockPos pos, int radius, String dimension) {
            this.visibility = visibility;
            this.pos = pos;
            this.radius = radius;
            this.dimension = dimension;
        }

        public VisitLocationTask.Visibility getVisibility() {
            return this.visibility;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getRadius() {
            return this.radius;
        }

        public String getDimension() {
            return this.dimension;
        }
    }

    private abstract class TextBoxNumberNegative
    extends GuiEditMenuExtended.TextBoxNumber {
        public TextBoxNumberNegative(GuiQuestBook gui, int id, String title) {
            super(LocationMenu.this, gui, id, title);
        }

        @Override
        protected boolean isNegativeAllowed() {
            return true;
        }
    }
}

