/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.TriggerType;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;

public class GuiEditMenuTrigger
extends GuiEditMenuExtended {
    private TriggerType type;
    private int triggerTasks;
    private UUID questId;

    public GuiEditMenuTrigger(GuiQuestBook gui, PlayerEntity player, Quest quest) {
        super(gui, player, true, 25, 20, 25, 135);
        this.questId = quest.getQuestId();
        this.type = quest.getTriggerType();
        this.triggerTasks = quest.getTriggerTasks();
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber((GuiBase)gui, 0, "hqm.menuTrigger.taskCount"){

            @Override
            protected int getValue() {
                return GuiEditMenuTrigger.this.triggerTasks;
            }

            @Override
            protected void setValue(int number) {
                GuiEditMenuTrigger.this.triggerTasks = number;
            }

            @Override
            protected boolean isVisible() {
                return GuiEditMenuTrigger.this.type.isUseTaskCount();
            }
        });
    }

    @Override
    protected void onArrowClick(boolean left) {
        this.type = left ? TriggerType.values()[(this.type.ordinal() + TriggerType.values().length - 1) % TriggerType.values().length] : TriggerType.values()[(this.type.ordinal() + 1) % TriggerType.values().length];
    }

    @Override
    protected String getArrowText() {
        return this.type.getName();
    }

    @Override
    protected String getArrowDescription() {
        return this.type.getDescription();
    }

    @Override
    public void save(GuiBase gui) {
        Quest quest = Quest.getQuest(this.questId);
        if (quest != null) {
            quest.setTriggerType(this.type);
            quest.setTriggerTasks(Math.max(1, this.triggerTasks));
            SaveHelper.add(EditType.VISIBILITY_CHANGED);
        }
    }
}

