/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.common.forge.tileentity.TrackerBlockEntity;
import hardcorequesting.common.forge.tileentity.TrackerType;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;

public class GuiEditMenuTracker
extends GuiEditMenuExtended {
    private TrackerBlockEntity tracker;

    public GuiEditMenuTracker(GuiBase gui, PlayerEntity player, final TrackerBlockEntity tracker) {
        super(gui, player, true, 20, 30, 20, 130);
        this.tracker = tracker;
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber(gui, 0, "hqm.menuTracker.radius.title"){

            @Override
            protected void draw(MatrixStack matrices, GuiBase gui, boolean selected) {
                super.draw(matrices, gui, selected);
                gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.menuTracker.radius.desc", new Object[0]), 0.7f, 130), GuiEditMenuTracker.this.BOX_X, GuiEditMenuTracker.this.BOX_Y + 30 + -10, 0.7f, 0x404040);
            }

            @Override
            protected int getValue() {
                return tracker.getRadius();
            }

            @Override
            protected void setValue(int number) {
                tracker.setRadius(number);
            }
        });
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.draw(matrices, gui, mX, mY);
        gui.drawCenteredString(matrices, (ITextProperties)(this.tracker.getCurrentQuest() != null ? Translator.plain(this.tracker.getCurrentQuest().getName()) : Translator.translatable("hqm.menuTracker.noQuest", new Object[0])), 0, 5, 1.0f, 170, 20, 0x404040);
    }

    @Override
    protected void onArrowClick(boolean left) {
        if (left) {
            this.tracker.setTrackerType(TrackerType.values()[(this.tracker.getTrackerType().ordinal() + TrackerType.values().length - 1) % TrackerType.values().length]);
        } else {
            this.tracker.setTrackerType(TrackerType.values()[(this.tracker.getTrackerType().ordinal() + 1) % TrackerType.values().length]);
        }
    }

    @Override
    protected String getArrowText() {
        return this.tracker.getTrackerType().getName();
    }

    @Override
    protected String getArrowDescription() {
        return this.tracker.getTrackerType().getDescription();
    }

    @Override
    public void save(GuiBase gui) {
        this.tracker.sendToServer();
    }

    @Override
    public boolean doesRequiredDoublePage() {
        return false;
    }
}

