/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.LargeButton;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.TextBoxGroup;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuTeamList;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamError;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;

public class GuiEditMenuTeam
extends GuiEditMenu {
    private static final int TEXT_HEIGHT = 9;
    private static final int TITLE_X = 20;
    private static final int TITLE_Y = 20;
    private static final int PLAYER_X = 25;
    private static final int PLAYER_Y = 32;
    private static final int PLAYER_SPACING = 11;
    private static final int VISIBLE_INVITES = 16;
    private static final int VISIBLE_MEMBERS = 16;
    private static final int INFO_BOX_X = 180;
    private static final int INFO_BOX_SIZE = 16;
    private static final int INFO_BOX_TEXT_OFFSET_X = 20;
    private static final int INFO_BOX_TEXT_OFFSET_Y = 6;
    private static final int INFO_BOX_SRC_X = 240;
    private static final int INFO_BOX_SRC_Y = 224;
    private static final int REWARD_SETTING_Y = 20;
    private GuiEditMenuTeam self = this;
    private ScrollBar memberScroll;
    private ScrollBar inviteScroll;
    private List<ScrollBar> scrollBars;
    private LargeButton inviteButton;
    private Team inviteTeam;
    private TextBoxGroup textBoxes;
    private TextBoxGroup.TextBox teamName;
    private TextBoxGroup.TextBox inviteName;
    private PlayerEntry selectedEntry;

    public GuiEditMenuTeam(GuiQuestBook gui, PlayerEntity player) {
        super(gui, player);
        this.buttons.add(new LargeButton("hqm.party.create", 250, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return GuiEditMenuTeam.this.teamName.getText().length() > 0;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiEditMenuTeam.this.inviteTeam == null && GuiEditMenuTeam.this.getTeam().isSingle();
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuTeam.this.getTeam().create(GuiEditMenuTeam.this.teamName.getText());
            }
        });
        this.inviteButton = new LargeButton("hqm.party.invitePlayer", 250, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return GuiEditMenuTeam.this.inviteName.getText().length() > 0;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return !GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.getEntry(GuiEditMenuTeam.this.getTeam()).isOwner();
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuTeam.this.getTeam().invite(GuiEditMenuTeam.this.inviteName.getText());
            }
        };
        this.buttons.add(this.inviteButton);
        this.buttons.add(new LargeButton("hqm.party.accept", 180, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiEditMenuTeam.this.inviteTeam != null;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuTeam.this.inviteTeam.accept();
                GuiEditMenuTeam.this.inviteTeam = null;
            }
        });
        this.buttons.add(new LargeButton("hqm.party.decline", 240, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiEditMenuTeam.this.inviteTeam != null;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuTeam.this.inviteTeam.decline();
                GuiEditMenuTeam.this.inviteTeam = null;
            }
        });
        this.buttons.add(new LargeButton("hqm.party.decideLater", 180, 40){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiEditMenuTeam.this.inviteTeam != null;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuTeam.this.inviteTeam = null;
            }
        });
        this.buttons.add(new LargeButton(null, 250, 50){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return !GuiEditMenuTeam.this.selectedEntry.isOwner();
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiEditMenuTeam.this.selectedEntry != null && GuiEditMenuTeam.this.getEntry(GuiEditMenuTeam.this.getTeam()).isOwner();
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuTeam.this.getTeam().kick(GuiEditMenuTeam.this.selectedEntry.getUUID());
                GuiEditMenuTeam.this.selectedEntry = null;
            }

            @Override
            protected ITextProperties getName() {
                return Translator.translatable(GuiEditMenuTeam.this.selectedEntry.isInTeam() ? "hqm.party.kickPlayer" : "hqm.party.removeInvite", new Object[0]);
            }
        });
        this.buttons.add(new LargeButton("hqm.party.leave", 250, 160){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return Screen.func_231173_s_();
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return !GuiEditMenuTeam.this.getTeam().isSingle() && !GuiEditMenuTeam.this.getEntry(GuiEditMenuTeam.this.getTeam()).isOwner();
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuTeam.this.getTeam().leave();
            }
        });
        this.buttons.add(new LargeButton("hqm.party.disband", 250, 160){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return Screen.func_231173_s_() && Screen.func_231172_r_();
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return !GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.selectedEntry != null && GuiEditMenuTeam.this.selectedEntry.isOwner();
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuTeam.this.getTeam().disband();
                GuiEditMenuTeam.this.selectedEntry = null;
            }
        });
        this.buttons.add(new LargeButton("hqm.party.list", 250, 190){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                gui.setEditMenu(new GuiEditMenuTeamList((GuiQuestBook)gui, player, GuiEditMenuTeam.this.self));
            }
        });
        this.textBoxes = new TextBoxGroup();
        this.teamName = new TextBoxName(gui, "", 180, 26){

            @Override
            protected boolean isVisible() {
                return GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.inviteTeam == null;
            }
        };
        this.textBoxes.add(this.teamName);
        this.teamName.setWidth(98);
        this.inviteName = new TextBoxName(gui, "", 180, 26){

            @Override
            protected boolean isVisible() {
                return !GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.getEntry(GuiEditMenuTeam.this.getTeam()).isOwner();
            }
        };
        this.textBoxes.add(this.inviteName);
        this.scrollBars = new ArrayList<ScrollBar>();
        this.inviteScroll = new ScrollBar(155, 22, 186, 171, 69, 25){

            @Override
            public boolean isVisible(GuiBase gui) {
                return GuiEditMenuTeam.this.inviteTeam == null && GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.getTeam().getInvites() != null && GuiEditMenuTeam.this.getTeam().getInvites().size() > 16;
            }
        };
        this.scrollBars.add(this.inviteScroll);
        this.memberScroll = new ScrollBar(155, 22, 186, 171, 69, 25){

            @Override
            public boolean isVisible(GuiBase gui) {
                return GuiEditMenuTeam.this.inviteTeam != null && GuiEditMenuTeam.this.inviteTeam.getPlayers().size() > 16 || !GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.getTeam().getPlayers().size() > 16;
            }
        };
        this.scrollBars.add(this.memberScroll);
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        Team team = this.getTeam();
        PlayerEntry entry = this.getEntry(team);
        if (Team.reloadedInvites) {
            if (this.inviteTeam != null) {
                if (team.getInvites() == null) {
                    this.inviteTeam = null;
                } else {
                    boolean stillThere = false;
                    for (Team t : team.getInvites()) {
                        if (!t.getName().equals(this.inviteTeam.getName())) continue;
                        this.inviteTeam = t;
                        stillThere = true;
                    }
                    if (!stillThere) {
                        this.inviteTeam = null;
                    }
                }
            }
            Team.reloadedInvites = false;
        }
        super.draw(matrices, gui, mX, mY);
        this.textBoxes.draw(matrices, gui);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.draw(gui);
        }
        if (team.isSingle() && this.inviteTeam == null) {
            int inviteCount;
            int n = inviteCount = team.getInvites() == null ? 0 : team.getInvites().size();
            if (inviteCount > 0) {
                gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.party.invites", new Object[0]), 20, 20, 0x404040);
                List<Team> invites = team.getInvites();
                int start = this.inviteScroll.isVisible(gui) ? Math.round((float)(team.getInvites().size() - 16) * this.inviteScroll.getScroll()) : 0;
                int end = Math.min(invites.size(), start + 16);
                for (int i = start; i < end; ++i) {
                    Team invite = invites.get(i);
                    gui.drawString(matrices, Translator.plain(invite.getName()), 25, 32 + 11 * (i - start), 0x404040);
                }
            } else {
                gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.party.noInvites", new Object[0]), 20, 20, 0x404040);
            }
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.party.name", new Object[0]), 180, 20, 0.7f, 0x404040);
        } else {
            boolean isOwner = this.inviteTeam == null && entry.isOwner();
            String title = (this.inviteTeam == null ? team : this.inviteTeam).getName();
            gui.drawString(matrices, Translator.plain(title), 20, 20, 0x404040);
            List<PlayerEntry> players = (this.inviteTeam == null ? team : this.inviteTeam).getPlayers();
            int y = 0;
            int start = this.memberScroll.isVisible(gui) ? Math.round((float)((isOwner ? players.size() : (this.inviteTeam == null ? team : this.inviteTeam).getPlayerCount()) - 16) * this.memberScroll.getScroll()) : 0;
            for (PlayerEntry player : players) {
                String str = player.getDisplayName();
                if (player.isOwner()) {
                    str = str + (Object)((Object)GuiColor.ORANGE) + " [" + I18n.func_135052_a((String)"hqm.party.owner", (Object[])new Object[0]) + "]";
                } else if (!player.isInTeam()) {
                    if (!isOwner) continue;
                    str = str + (Object)((Object)GuiColor.LIGHT_GRAY) + " [" + I18n.func_135052_a((String)"hqm.party.invite", (Object[])new Object[0]) + "]";
                }
                if (y >= start) {
                    int color = 0x404040;
                    if (isOwner) {
                        if (player.equals(this.selectedEntry)) {
                            color = 0xD0D0D0;
                        } else if (gui.inBounds(25, 32 + 11 * (y - start), (int)((float)gui.getStringWidth(player.getDisplayName()) * 0.7f), 6, mX, mY)) {
                            color = 0x808080;
                        }
                    }
                    gui.drawString(matrices, Translator.plain(str), 25, 32 + 11 * (y - start), 0.7f, color);
                }
                if (++y != start + 16) continue;
                break;
            }
            if (this.inviteTeam == null) {
                if (entry.isOwner()) {
                    gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.party.playerName", new Object[0]), 180, 20, 0.7f, 0x404040);
                    if (this.selectedEntry != null) {
                        gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.party.currentSelection", this.selectedEntry.getDisplayName()), 0.7f, 70), 177, 52, 0.7f, 0x404040);
                        if (this.selectedEntry.isOwner()) {
                            gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.party.shiftCtrlConfirm", new Object[0]), 0.6f, 70), 177, 162, 0.6f, GuiColor.RED.getHexColor());
                        }
                    }
                } else {
                    gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.party.shiftConfirm", new Object[0]), 0.7f, 70), 177, 162, 0.7f, GuiColor.RED.getHexColor());
                }
            }
            gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.party.stats", new Object[0]), 0.7f, 70), 177, 192, 0.7f, 0x404040);
            Team infoTeam = this.inviteTeam == null ? team : this.inviteTeam;
            int infoY = this.getInfoY();
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.drawRect(180, infoY, 240, 224, 16, 16);
            gui.drawRect(180, infoY + 20, 240, 224, 16, 16);
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.party.lifeSetting", infoTeam.getLifeSetting().getTitle()), 200, infoY + 6, 0.7f, 0x404040);
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.party.rewardSetting", infoTeam.getRewardSetting().getTitle()), 200, infoY + 20 + 6, 0.7f, 0x404040);
        }
    }

    @Override
    public void renderTooltip(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        boolean isOwner;
        super.renderTooltip(matrices, gui, mX, mY);
        Team team = this.getTeam();
        PlayerEntry entry = this.getEntry(team);
        boolean bl = isOwner = this.inviteTeam == null && entry.isOwner();
        if (!team.isSingle() || this.inviteTeam != null) {
            Team infoTeam;
            int infoY = this.getInfoY();
            Team team2 = infoTeam = this.inviteTeam == null ? team : this.inviteTeam;
            if (gui.inBounds(180, infoY, 16, 16, mX, mY)) {
                gui.renderTooltipL(matrices, gui.getLinesFromText(Translator.plain((Object)((Object)GuiColor.GREEN) + infoTeam.getLifeSetting().getTitle() + "\n" + infoTeam.getLifeSetting().getDescription() + (isOwner ? "\n\n" + (Object)((Object)GuiColor.ORANGE) + I18n.func_135052_a((String)"hqm.party.change", (Object[])new Object[0]) : "")), 1.0f, 200), gui.getLeft() + mX, gui.getTop() + mY);
            } else if (gui.inBounds(180, infoY + 20, 16, 16, mX, mY)) {
                gui.renderTooltipL(matrices, gui.getLinesFromText(Translator.plain((Object)((Object)GuiColor.GREEN) + infoTeam.getRewardSetting().getTitle() + "\n" + infoTeam.getRewardSetting().getDescription() + (isOwner ? "\n\n" + (Object)((Object)GuiColor.ORANGE) + I18n.func_135052_a((String)"hqm.party.change", (Object[])new Object[0]) : "")), 1.0f, 200), gui.getLeft() + mX, gui.getTop() + mY);
            }
        }
        if (TeamError.latestError != null) {
            if (this.inviteButton.inButtonBounds(gui, mX, mY)) {
                gui.renderTooltipL(matrices, gui.getLinesFromText(Translator.plain((Object)((Object)GuiColor.RED) + TeamError.latestError.getHeader() + "\n" + TeamError.latestError.getMessage()), 1.0f, 150), mX + gui.getLeft(), mY + gui.getTop());
            } else {
                TeamError.latestError = null;
            }
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        Team team = this.getTeam();
        if (team.isSingle() && this.inviteTeam == null) {
            List<Team> invites = team.getInvites();
            if (invites != null) {
                int start = this.inviteScroll.isVisible(gui) ? Math.round((float)(team.getInvites().size() - 16) * this.inviteScroll.getScroll()) : 0;
                int end = Math.min(invites.size(), start + 16);
                for (int i = start; i < end; ++i) {
                    Team invite = invites.get(i);
                    if (!gui.inBounds(25, 32 + 11 * i, (int)((float)gui.getStringWidth(invite.getName()) * 0.7f), 6, mX, mY)) continue;
                    this.inviteTeam = invite;
                    break;
                }
            }
        } else if (!team.isSingle() && this.getEntry(team).isOwner()) {
            int infoY;
            int start = this.memberScroll.isVisible(gui) ? Math.round((float)(team.getPlayers().size() - 16) * this.memberScroll.getScroll()) : 0;
            int end = Math.min(team.getPlayers().size(), start + 16);
            for (int i = start; i < end; ++i) {
                PlayerEntry entry = team.getPlayers().get(i);
                if (!gui.inBounds(25, 32 + 11 * (i - start), (int)((float)gui.getStringWidth(entry.getDisplayName()) * 0.7f), 6, mX, mY)) continue;
                this.selectedEntry = this.selectedEntry == entry ? null : entry;
                break;
            }
            if (gui.inBounds(180, infoY = this.getInfoY(), 16, 16, mX, mY)) {
                team.nextLifeSetting();
            } else if (gui.inBounds(180, infoY + 20, 16, 16, mX, mY)) {
                team.nextRewardSetting();
            }
        }
        this.textBoxes.onClick(gui, mX, mY);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onClick(gui, mX, mY);
        }
    }

    @Override
    public void onKeyStroke(GuiBase gui, char c, int k) {
        super.onKeyStroke(gui, c, k);
        this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void onDrag(GuiBase gui, int mX, int mY) {
        super.onDrag(gui, mX, mY);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onDrag(gui, mX, mY);
        }
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onRelease(gui, mX, mY);
        }
    }

    @Override
    public void onScroll(GuiBase gui, double mX, double mY, double scroll) {
        super.onScroll(gui, mX, mY, scroll);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onScroll(gui, mX, mY, scroll);
        }
    }

    @Override
    public void save(GuiBase gui) {
    }

    private int getInfoY() {
        if (this.inviteTeam != null) {
            return 80;
        }
        if (this.getEntry(this.getTeam()).isOwner()) {
            return this.selectedEntry != null ? 80 : 50;
        }
        return 20;
    }

    private Team getTeam() {
        return QuestingDataManager.getInstance().getQuestingData(this.player).getTeam();
    }

    private PlayerEntry getEntry(Team team) {
        return team.getEntry(this.player.func_110124_au());
    }

    private static class TextBoxName
    extends TextBoxGroup.TextBox {
        public TextBoxName(GuiQuestBook gui, String str, int x, int y) {
            super(gui, str, x, y, true);
            this.setMult(0.7f);
            this.offsetY = 5;
        }
    }
}

