/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;

public class GuiEditMenuReputationSetting
extends GuiEditMenuExtended {
    private static final int BARS_X = 20;
    private static final int LOWER_Y = 50;
    private static final int UPPER_Y = 90;
    private static final int RESULT_Y = 150;
    private static final int BAR_OFFSET_Y = 10;
    private Reputation reputation;
    private int reputationId;
    private ReputationMarker lower;
    private ReputationMarker upper;
    private boolean inverted;
    private ReputationTask task;
    private int id;

    public GuiEditMenuReputationSetting(GuiQuestBook gui, PlayerEntity player, ReputationTask task, int id, ReputationTask.Part setting) {
        super(gui, player, true, 25, 25, -1, -1);
        this.task = task;
        this.id = id;
        ReputationManager reputationManager = ReputationManager.getInstance();
        if (setting.getReputation() == null) {
            if (!reputationManager.getReputations().isEmpty()) {
                this.reputation = reputationManager.getReputationList().get(0);
                this.reputationId = 0;
            } else {
                this.reputationId = -1;
            }
        } else {
            this.reputation = setting.getReputation();
            id = -1;
            ArrayList<Reputation> reputationList = new ArrayList<Reputation>(reputationManager.getReputations().values());
            for (int i = 0; i < reputationList.size(); ++i) {
                Reputation element = (Reputation)reputationList.get(i);
                if (!element.equals(this.reputation)) continue;
                id = i;
                break;
            }
            if (id == -1) {
                this.reputation = null;
            } else {
                this.lower = setting.getLower();
                this.upper = setting.getUpper();
                this.inverted = setting.isInverted();
            }
        }
        this.checkboxes.add(new GuiEditMenu.CheckBox("hqm.repSetting.invRange", 21, 124){

            @Override
            protected boolean isVisible() {
                return GuiEditMenuReputationSetting.this.reputation != null;
            }

            @Override
            public boolean getValue() {
                return GuiEditMenuReputationSetting.this.inverted;
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuReputationSetting.this.inverted = val;
            }
        });
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.draw(matrices, gui, mX, mY);
        if (this.reputation != null) {
            String info = null;
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.repSetting.lower", new Object[0]), 20, 50, 0x404040);
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = this.reputation.draw(matrices, (GuiQuestBook)gui, 20, 60, mX, mY, info, this.player, false, null, null, false, this.lower, this.lower == null ? "" : "Selected: " + this.lower.getLabel(), false);
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.repSetting.upper", new Object[0]), 20, 90, 0x404040);
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = this.reputation.draw(matrices, (GuiQuestBook)gui, 20, 100, mX, mY, info, this.player, false, null, null, false, this.upper, this.upper == null ? "" : "Selected: " + this.upper.getLabel(), false);
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.repSetting.preview", new Object[0]), 20, 150, 0x404040);
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = this.reputation.draw(matrices, (GuiQuestBook)gui, 20, 160, mX, mY, info, this.player, true, this.lower, this.upper, this.inverted, null, null, false);
            if (info != null) {
                gui.renderTooltip(matrices, Translator.plain(info), mX + gui.getLeft(), mY + gui.getTop());
            }
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        if (this.reputation != null) {
            ReputationMarker marker = this.reputation.onActiveClick((GuiQuestBook)gui, 20, 60, mX, mY);
            if (marker != null) {
                this.lower = marker.equals(this.lower) ? null : marker;
            } else {
                marker = this.reputation.onActiveClick((GuiQuestBook)gui, 20, 100, mX, mY);
                if (marker != null) {
                    this.upper = marker.equals(this.upper) ? null : marker;
                }
            }
        }
    }

    @Override
    protected void onArrowClick(boolean left) {
        if (this.reputation != null) {
            ReputationManager reputationManager = ReputationManager.getInstance();
            this.reputationId += left ? -1 : 1;
            if (this.reputationId < 0) {
                this.reputationId = reputationManager.getReputations().size() - 1;
            } else if (this.reputationId >= reputationManager.getReputations().size()) {
                this.reputationId = 0;
            }
            this.lower = null;
            this.upper = null;
            this.reputation = reputationManager.getReputationList().get(this.reputationId);
        }
    }

    @Override
    protected String getArrowText() {
        if (ReputationManager.getInstance().getReputations().isEmpty()) {
            return I18n.func_135052_a((String)"hqm.repSetting.invalid", (Object[])new Object[0]);
        }
        return this.reputation != null ? this.reputation.getName() : I18n.func_135052_a((String)"hqm.repSetting.invalid", (Object[])new Object[0]);
    }

    @Override
    protected String getArrowDescription() {
        if (ReputationManager.getInstance().getReputations().isEmpty()) {
            return I18n.func_135052_a((String)"hqm.repReward.noValidReps", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public void save(GuiBase gui) {
        if (this.reputation != null) {
            this.task.setSetting(this.id, new ReputationTask.Part(this.reputation, this.lower, this.upper, this.inverted));
        }
    }
}

