/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.LargeButton;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.common.forge.quests.reward.ReputationReward;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;

public class GuiEditMenuReputationReward
extends GuiEditMenuExtended {
    private static final int START_X = 20;
    private static final int START_Y = 50;
    private static final int ERROR_Y = 20;
    private static final int OFFSET = 15;
    private List<ReputationReward> rewards = new ArrayList<ReputationReward>();
    private ReputationReward selectedReward;
    private List<ITextProperties> error;

    public GuiEditMenuReputationReward(GuiBase gui, PlayerEntity player, List<ReputationReward> rewards) {
        super(gui, player, true, 185, 25, 185, 55);
        if (rewards != null) {
            for (ReputationReward reward : rewards) {
                this.rewards.add(new ReputationReward((Reputation)reward.getReward(), reward.getValue()));
            }
        }
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber(gui, 0, "hqm.repReward.value"){

            @Override
            protected boolean isVisible() {
                return GuiEditMenuReputationReward.this.selectedReward != null;
            }

            @Override
            protected boolean isNegativeAllowed() {
                return true;
            }

            @Override
            protected int getValue() {
                return GuiEditMenuReputationReward.this.selectedReward.getValue();
            }

            @Override
            protected void setValue(int number) {
                GuiEditMenuReputationReward.this.selectedReward.setValue(number);
            }
        });
        this.buttons.add(new LargeButton("hqm.repReward.create", 20, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiEditMenuReputationReward.this.isValid();
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuReputationReward.this.rewards.add(new ReputationReward(ReputationManager.getInstance().getReputationList().get(0), 0));
            }
        });
        this.buttons.add(new LargeButton("hqm.repReward.delete", 80, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiEditMenuReputationReward.this.isValid() && GuiEditMenuReputationReward.this.selectedReward != null;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenuReputationReward.this.rewards.remove(GuiEditMenuReputationReward.this.selectedReward);
                GuiEditMenuReputationReward.this.selectedReward = null;
            }
        });
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.draw(matrices, gui, mX, mY);
        if (this.isValid()) {
            for (int i = 0; i < this.rewards.size(); ++i) {
                ITextProperties str = Translator.plain(this.rewards.get(i).getLabel());
                boolean hover = gui.inBounds(20, 50 + i * 15, gui.getStringWidth(str), 9, mX, mY);
                boolean selected = this.rewards.get(i).equals(this.selectedReward);
                gui.drawString(matrices, str, 20, 50 + i * 15, selected ? (hover ? 0x40CC40 : 0x409040) : (hover ? 0xAAAAAA : 0x404040));
            }
        } else {
            if (this.error == null) {
                this.error = gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.repReward.noValidReps", new Object[0]), 0.7f, 140);
            }
            gui.drawString(matrices, this.error, 20, 20, 0.7f, 0x404040);
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        if (this.isValid()) {
            for (int i = 0; i < this.rewards.size(); ++i) {
                if (!gui.inBounds(20, 50 + i * 15, gui.getStringWidth(this.rewards.get(i).getLabel()), 9, mX, mY)) continue;
                if (this.rewards.get(i).equals(this.selectedReward)) {
                    this.selectedReward = null;
                    break;
                }
                this.selectedReward = this.rewards.get(i);
                this.textBoxes.getTextBoxes().get(0).reloadText(gui);
                break;
            }
        }
    }

    @Override
    protected boolean isArrowVisible() {
        return this.isValid() && this.selectedReward != null;
    }

    @Override
    protected void onArrowClick(boolean left) {
        if (this.selectedReward != null && this.selectedReward.getReward() != null) {
            ReputationManager reputationManager = ReputationManager.getInstance();
            for (int i = 0; i < reputationManager.getReputationList().size(); ++i) {
                if (!reputationManager.getReputationList().get(i).equals(this.selectedReward.getReward())) continue;
                int id = i + (left ? -1 : 1);
                if (id < 0) {
                    id = reputationManager.getReputationList().size() - 1;
                } else if (id >= reputationManager.getReputationList().size()) {
                    id = 0;
                }
                this.selectedReward.setReward(reputationManager.getReputationList().get(id));
                break;
            }
        }
    }

    @Override
    protected String getArrowText() {
        return ((Reputation)this.selectedReward.getReward()).getName();
    }

    @Override
    protected String getArrowDescription() {
        return null;
    }

    private boolean isValid() {
        return !ReputationManager.getInstance().getReputationList().isEmpty();
    }

    @Override
    public void save(GuiBase gui) {
        GuiQuestBook.selectedQuest.setReputationRewards(this.rewards.isEmpty() ? null : this.rewards);
        SaveHelper.add(EditType.REPUTATION_REWARD_CHANGE);
    }
}

