/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.RepeatInfo;
import hardcorequesting.common.forge.quests.RepeatType;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;

public class GuiEditMenuRepeat
extends GuiEditMenuExtended {
    private Quest quest;
    private RepeatType type;
    private int days;
    private int hours;

    public GuiEditMenuRepeat(GuiQuestBook gui, PlayerEntity player, Quest quest) {
        super(gui, player, true, 25, 20, 25, 100);
        this.quest = quest;
        this.type = quest.getRepeatInfo().getType();
        this.days = quest.getRepeatInfo().getDays();
        this.hours = quest.getRepeatInfo().getHours();
        this.textBoxes.add(new TextBoxHidden(gui, 0, "hqm.repeatMenu.days"){

            @Override
            protected int getValue() {
                return GuiEditMenuRepeat.this.days;
            }

            @Override
            protected void setValue(int number) {
                GuiEditMenuRepeat.this.days = number;
            }
        });
        this.textBoxes.add(new TextBoxHidden(gui, 1, "hqm.repeatMenu.hours"){

            @Override
            protected void draw(MatrixStack matrices, GuiBase gui, boolean selected) {
                super.draw(matrices, gui, selected);
                gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.repeatMenu.mcDaysHours", new Object[0]), 0.7f, 150), GuiEditMenuRepeat.this.BOX_X, GuiEditMenuRepeat.this.BOX_Y + 60 + -10, 0.7f, 0x404040);
            }

            @Override
            protected int getValue() {
                return GuiEditMenuRepeat.this.hours;
            }

            @Override
            protected void setValue(int number) {
                GuiEditMenuRepeat.this.hours = number;
            }
        });
    }

    @Override
    public void save(GuiBase gui) {
        this.quest.setRepeatInfo(new RepeatInfo(this.type, this.days, this.hours));
        SaveHelper.add(EditType.REPEATABILITY_CHANGED);
    }

    @Override
    protected void onArrowClick(boolean left) {
        this.type = left ? RepeatType.values()[(this.type.ordinal() + RepeatType.values().length - 1) % RepeatType.values().length] : RepeatType.values()[(this.type.ordinal() + 1) % RepeatType.values().length];
    }

    @Override
    protected String getArrowText() {
        return this.type.getName();
    }

    @Override
    protected String getArrowDescription() {
        return this.type.getDescription();
    }

    private abstract class TextBoxHidden
    extends GuiEditMenuExtended.TextBoxNumber {
        public TextBoxHidden(GuiQuestBook gui, int id, String title) {
            super(GuiEditMenuRepeat.this, gui, id, title);
        }

        @Override
        protected boolean isVisible() {
            return GuiEditMenuRepeat.this.type.isUseTime();
        }
    }
}

