/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;

public class GuiEditMenuParentCount
extends GuiEditMenuExtended {
    private boolean showModifiedParentRequirement;
    private int parentRequirementCount;
    private Quest quest;

    public GuiEditMenuParentCount(GuiBase gui, PlayerEntity player, Quest quest) {
        super(gui, player, true, 25, 20, 25, 105);
        this.quest = quest;
        this.parentRequirementCount = quest._getParentRequirementCount();
        this.showModifiedParentRequirement = quest.getUseModifiedParentRequirement();
        if (!this.showModifiedParentRequirement) {
            this.parentRequirementCount = quest.getRequirements().size();
        }
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber(gui, 0, "hqm.parentCount.count"){

            @Override
            protected int getValue() {
                return GuiEditMenuParentCount.this.parentRequirementCount;
            }

            @Override
            protected void setValue(int number) {
                GuiEditMenuParentCount.this.parentRequirementCount = number;
            }

            @Override
            protected boolean isVisible() {
                return GuiEditMenuParentCount.this.showModifiedParentRequirement;
            }
        });
    }

    @Override
    protected void onArrowClick(boolean left) {
        this.showModifiedParentRequirement = !this.showModifiedParentRequirement;
    }

    @Override
    protected String getArrowText() {
        return I18n.func_135052_a((String)("hqm.parentCount.req" + (this.showModifiedParentRequirement ? "Count" : "All") + ".title"), (Object[])new Object[0]);
    }

    @Override
    protected String getArrowDescription() {
        return I18n.func_135052_a((String)("hqm.parentCount.req" + (this.showModifiedParentRequirement ? "Count" : "All") + ".desc"), (Object[])new Object[0]);
    }

    @Override
    public void save(GuiBase gui) {
        this.quest.setParentRequirementCount(this.showModifiedParentRequirement ? this.parentRequirementCount : -1);
        SaveHelper.add(EditType.PARENT_REQUIREMENT_CHANGED);
    }
}

