/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.TextBoxGroup;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;

public abstract class GuiEditMenuExtended
extends GuiEditMenu {
    private static final int ARROW_SRC_X = 244;
    private static final int ARROW_SRC_Y = 176;
    private static final int ARROW_W = 6;
    private static final int ARROW_H = 10;
    protected final int BOX_X;
    protected final int BOX_Y;
    protected final int BOX_OFFSET = 30;
    protected final int TEXT_OFFSET = -10;
    private final int ARROW_X_LEFT;
    private final int ARROW_Y;
    private final int ARROW_DESCRIPTION_Y;
    private final int ARROW_X_RIGHT;
    protected TextBoxGroup textBoxes = new TextBoxGroup();
    private boolean clicked;

    protected GuiEditMenuExtended(GuiBase gui, PlayerEntity player, boolean isControlOnFirstPage, int arrowX, int arrowY, int boxX, int boxY) {
        super(gui, player, isControlOnFirstPage);
        this.ARROW_X_LEFT = arrowX;
        this.ARROW_Y = arrowY;
        this.ARROW_DESCRIPTION_Y = this.ARROW_Y + 20;
        this.ARROW_X_RIGHT = this.ARROW_X_LEFT + 130;
        this.BOX_X = boxX;
        this.BOX_Y = boxY;
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.draw(matrices, gui, mX, mY);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isArrowVisible()) {
            this.drawArrow(gui, mX, mY, true);
            this.drawArrow(gui, mX, mY, false);
            gui.drawCenteredString(matrices, Translator.plain(this.getArrowText()), this.ARROW_X_LEFT + 6, this.ARROW_Y, 0.7f, this.ARROW_X_RIGHT - (this.ARROW_X_LEFT + 6), 10, 0x404040);
            String description = this.getArrowDescription();
            if (description != null) {
                gui.drawString(matrices, gui.getLinesFromText(Translator.plain(description), 0.7f, this.ARROW_X_RIGHT - this.ARROW_X_LEFT + 6), this.ARROW_X_LEFT, this.ARROW_DESCRIPTION_Y, 0.7f, 0x404040);
            }
        }
        this.textBoxes.draw(matrices, gui);
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        if (this.isArrowVisible()) {
            if (this.inArrowBounds(gui, mX, mY, true)) {
                this.onArrowClick(true);
                this.clicked = true;
            } else if (this.inArrowBounds(gui, mX, mY, false)) {
                this.onArrowClick(false);
                this.clicked = true;
            }
        }
        this.textBoxes.onClick(gui, mX, mY);
    }

    @Override
    public void onKeyStroke(GuiBase gui, char c, int k) {
        super.onKeyStroke(gui, c, k);
        this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        this.clicked = false;
    }

    protected boolean isArrowVisible() {
        return this.ARROW_Y != -1;
    }

    private void drawArrow(GuiBase gui, int mX, int mY, boolean left) {
        int srcX = 244 + (left ? 0 : 6);
        int srcY = 176 + (this.inArrowBounds(gui, mX, mY, left) ? (this.clicked ? 1 : 2) : 0) * 10;
        gui.drawRect(left ? this.ARROW_X_LEFT : this.ARROW_X_RIGHT, this.ARROW_Y, srcX, srcY, 6, 10);
    }

    private boolean inArrowBounds(GuiBase gui, int mX, int mY, boolean left) {
        return gui.inBounds(left ? this.ARROW_X_LEFT : this.ARROW_X_RIGHT, this.ARROW_Y, 6, 10, mX, mY);
    }

    protected abstract void onArrowClick(boolean var1);

    protected abstract String getArrowText();

    protected abstract String getArrowDescription();

    protected abstract class TextBoxNumber
    extends TextBoxGroup.TextBox {
        private String title;
        private int id;
        private boolean loaded;

        public TextBoxNumber(GuiBase gui, int id, String title) {
            super(gui, "", GuiEditMenuExtended.this.BOX_X, GuiEditMenuExtended.this.BOX_Y + 30 * id, false);
            this.loaded = true;
            this.reloadText(gui);
            this.title = title;
            this.id = id;
        }

        @Override
        protected boolean isCharacterValid(char c, String rest) {
            return rest.length() < 32 && (Character.isDigit(c) || c == '-' && this.isNegativeAllowed());
        }

        protected boolean isNegativeAllowed() {
            return false;
        }

        @Override
        protected void draw(MatrixStack matrices, GuiBase gui, boolean selected) {
            super.draw(matrices, gui, selected);
            gui.drawString(matrices, (ITextProperties)Translator.translatable(this.title, new Object[0]), GuiEditMenuExtended.this.BOX_X, GuiEditMenuExtended.this.BOX_Y + 30 * this.id + -10, 0x404040);
        }

        @Override
        public void textChanged(GuiBase gui) {
            if (this.loaded) {
                try {
                    int number = this.getText().equals("") ? 1 : Integer.parseInt(this.getText());
                    this.setValue(number);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void reloadText(GuiBase gui) {
            this.setTextAndCursor(gui, this.isVisible() ? String.valueOf(this.getValue()) : "0");
        }

        protected abstract int getValue();

        protected abstract void setValue(int var1);
    }
}

