/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.death.DeathStat;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.death.DeathType;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiEditMenuDeath
extends GuiEditMenu {
    private static final int PLAYER_INFO_X = 180;
    private static final int PLAYER_INFO_Y = 20;
    private static final int PLAYER_TOTAL_DEATHS_Y = 12;
    private static final int BACKGROUND_SIZE = 22;
    private static final int ICON_OFFSET = 1;
    private static final int BACKGROUND_SRC_X = 234;
    private static final int BACKGROUND_SRC_Y = 55;
    private static final int ICON_SRC_X = 179;
    private static final int ICON_SRC_Y = 156;
    private static final int ICON_SIZE = 20;
    private static final int TYPE_LOCATION_X = 180;
    private static final int TYPE_LOCATION_Y = 50;
    private static final int TYPE_SPACING_X = 47;
    private static final int TYPE_SPACING_Y = 30;
    private static final int TEXT_OFFSET_X = 28;
    private static final int TEXT_OFFSET_Y = 7;
    private static final int PLAYERS_X = 20;
    private static final int PLAYERS_Y = 20;
    private static final int PLAYERS_SPACING = 20;
    private static final int DEATHS_RIGHT = 140;
    private static final String BEST_LABEL = "hqm.deathMenu.showWorst";
    private static final String TOTAL_LABEL = "hqm.deathMenu.showTotal";
    private static final int BEST_X = 185;
    private static final int TOTAL_X = 255;
    private static final int LABEL_Y = 210;
    private static final int VISIBLE_PLAYERS = 10;
    private static final float[] DIGIT_TEXT_SIZE = new float[]{1.0f, 1.0f, 0.8f, 0.6f, 0.4f};
    private UUID playerId;
    private boolean showTotal;
    private boolean showBest;
    private ScrollBar scrollBar;

    public GuiEditMenuDeath(GuiQuestBook guiQuestBook, PlayerEntity player) {
        super(guiQuestBook, player);
        this.playerId = player.func_110124_au();
        this.scrollBar = new ScrollBar(160, 18, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return DeathStatsManager.getInstance().getDeathStats().length > 10;
            }
        };
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.draw(matrices, gui, mX, mY);
        this.scrollBar.draw(gui);
        DeathStat[] deathStats = DeathStatsManager.getInstance().getDeathStats();
        int start = this.scrollBar.isVisible(gui) ? Math.round((float)(deathStats.length - 10) * this.scrollBar.getScroll()) : 0;
        int end = Math.min(deathStats.length, start + 10);
        for (int i = start; i < end; ++i) {
            DeathStat stats = deathStats[i];
            boolean selected = stats.getUuid().equals(this.playerId);
            boolean inBounds = gui.inBounds(20, 20 + (i - start) * 20, 130, 9, mX, mY);
            gui.drawString(matrices, Translator.plain(i + 1 + ". " + stats.getName()), 20, 20 + (i - start) * 20, this.getColor(selected, inBounds));
            String deaths = String.valueOf(stats.getTotalDeaths());
            gui.drawString(matrices, Translator.plain(deaths), 140 - gui.getStringWidth(deaths), 20 + (i - start) * 20, 0x404040);
        }
        gui.drawString(matrices, (ITextProperties)Translator.translatable(BEST_LABEL, new Object[0]), 185, 210, this.getColor(this.showBest, gui.inBounds(185, 210, gui.getStringWidth(BEST_LABEL), 9, mX, mY)));
        gui.drawString(matrices, (ITextProperties)Translator.translatable(TOTAL_LABEL, new Object[0]), 255, 210, this.getColor(this.showTotal, gui.inBounds(255, 210, gui.getStringWidth(TOTAL_LABEL), 9, mX, mY)));
        DeathStat stats = this.getDeathStat();
        if (stats != null) {
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < DeathType.values().length; ++i) {
                int x = i % 3;
                int y = i / 3;
                gui.drawRect(180 + 47 * x, 50 + 30 * y, 234, 55, 22, 22);
                gui.drawRect(180 + 47 * x + 1, 50 + 30 * y + 1, 179 + 20 * x, 156 + 20 * y, 20, 20);
            }
            gui.drawString(matrices, Translator.plain(stats.getName()), 180, 20, 0x404040);
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.deathMenu.total", stats.getTotalDeaths()), 180, 32, 0.7f, 0x404040);
            for (DeathType type : DeathType.values()) {
                float f;
                int i = type.ordinal();
                int x = i % 3;
                int y = i / 3;
                ITextProperties text = Translator.plain(stats.getDeaths(type) + "");
                String str = Translator.rawString(text);
                if (str.length() > 5) {
                    text = Translator.translatable("hqm.deathMenu.lots", new Object[0]);
                }
                int offset = (f = DIGIT_TEXT_SIZE[(str = Translator.rawString(text)).length() - 1]) == 1.0f ? 0 : Math.round(9.0f * (1.0f - f) - 1.0f);
                gui.drawString(matrices, text, 180 + 47 * x + 28, 50 + 30 * y + 7 + offset, f, 0x404040);
            }
        }
    }

    @Override
    public void renderTooltip(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        super.renderTooltip(matrices, gui, mX, mY);
        DeathStat stats = this.getDeathStat();
        if (stats != null) {
            for (DeathType type : DeathType.values()) {
                int y;
                int i = type.ordinal();
                int x = i % 3;
                if (!gui.inBounds(180 + 47 * x, 50 + 30 * (y = i / 3), 22, 22, mX, mY)) continue;
                gui.renderTooltip(matrices, Translator.plain(stats.getDescription(type)), mX + gui.getLeft(), mY + gui.getTop());
                break;
            }
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        this.scrollBar.onClick(gui, mX, mY);
        if (gui.inBounds(185, 210, gui.getStringWidth((ITextProperties)Translator.translatable(BEST_LABEL, new Object[0])), 9, mX, mY)) {
            this.showBest = !this.showBest;
            this.showTotal = false;
            this.playerId = null;
        } else if (gui.inBounds(255, 210, gui.getStringWidth((ITextProperties)Translator.translatable(TOTAL_LABEL, new Object[0])), 9, mX, mY)) {
            this.showBest = false;
            this.showTotal = !this.showTotal;
            this.playerId = null;
        } else {
            this.showTotal = false;
            this.showBest = false;
            DeathStat[] deathStats = DeathStatsManager.getInstance().getDeathStats();
            int start = this.scrollBar.isVisible(gui) ? Math.round((float)(deathStats.length - 10) * this.scrollBar.getScroll()) : 0;
            int end = Math.min(deathStats.length, start + 10);
            for (int i = start; i < end; ++i) {
                DeathStat stats = deathStats[i];
                if (!gui.inBounds(20, 20 + (i - start) * 20, 130, 9, mX, mY)) continue;
                this.playerId = stats.getUuid().equals(this.playerId) ? null : stats.getUuid();
            }
        }
    }

    @Override
    public void onDrag(GuiBase gui, int mX, int mY) {
        this.scrollBar.onDrag(gui, mX, mY);
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        this.scrollBar.onRelease(gui, mX, mY);
    }

    @Override
    public void onScroll(GuiBase gui, double mX, double mY, double scroll) {
        this.scrollBar.onScroll(gui, mX, mY, scroll);
    }

    @Override
    public void save(GuiBase gui) {
    }

    private DeathStat getDeathStat() {
        DeathStatsManager manager = DeathStatsManager.getInstance();
        if (this.showBest) {
            return manager.getBest();
        }
        if (this.showTotal) {
            return manager.getTotal();
        }
        if (this.playerId != null) {
            return manager.getDeathStat(this.playerId);
        }
        return null;
    }

    private int getColor(boolean selected, boolean inBounds) {
        return selected ? (inBounds ? 0xC0C0C0 : 0xA0A0A0) : (inBounds ? 0x707070 : 0x404040);
    }
}

