/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.TextMenu;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ICharacterConsumer;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextProcessing;
import net.minecraft.util.text.TextPropertiesManager;

public class GuiEditMenuCommandEditor
extends TextMenu {
    private Quest quest = GuiQuestBook.selectedQuest;
    private int id = -1;
    private String[] commands = this.quest.getCommandRewardsAsStrings();
    private boolean[] edited = new boolean[this.commands.length];
    private String added;

    public GuiEditMenuCommandEditor(GuiQuestBook gui, PlayerEntity player) {
        super(gui, player, "", false, -1, null);
        if (gui.getCurrentMode() == EditMode.COMMAND_CHANGE && this.commands.length > 0) {
            this.id = this.commands.length - 1;
            this.text.setTextAndCursor(gui, this.commands[this.id]);
        }
    }

    @Override
    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        int i;
        super.draw(matrices, gui, mX, mY);
        if (this.commands != null && this.commands.length > 0) {
            for (i = 0; i < this.commands.length; ++i) {
                if (this.commands[i].isEmpty()) {
                    this.drawStringTrimmed(matrices, gui, (ITextProperties)Translator.translatable("hqm.commandEdit.deleted", new Object[0]), 190, 65 + i * 10, 0xFF0000);
                    continue;
                }
                this.drawStringTrimmed(matrices, gui, Translator.plain(this.commands[i]), 190, 65 + i * 10, this.edited[i] ? 16729344 : 0);
            }
        }
        if (this.added != null && !this.added.isEmpty()) {
            this.drawStringTrimmed(matrices, gui, Translator.plain(this.added), 190, 65 + i * 10, 0x447449);
        }
    }

    @Override
    public void save(GuiBase gui) {
        if (this.id < 0) {
            this.added = this.text.getText();
        } else if (this.commands != null && !this.commands[this.id].equals(this.text.getText())) {
            this.edited[this.id] = true;
            this.commands[this.id] = this.text.getText();
        }
        if (this.added != null && !this.added.isEmpty()) {
            this.quest.addCommand(this.added);
            SaveHelper.add(EditType.COMMAND_ADD);
        }
        if (this.commands != null) {
            for (int i = this.commands.length - 1; i >= 0; --i) {
                if (!this.edited[i]) continue;
                if (this.commands[i].isEmpty()) {
                    this.quest.removeCommand(i);
                    SaveHelper.add(EditType.COMMAND_REMOVE);
                    continue;
                }
                this.quest.editCommand(i, this.commands[i]);
                SaveHelper.add(EditType.COMMAND_CHANGE);
            }
        }
    }

    @Override
    public void renderTooltip(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        int i;
        super.renderTooltip(matrices, gui, mX, mY);
        if (this.commands != null && this.commands.length > 0) {
            for (i = 0; i < this.commands.length; ++i) {
                if (mX <= 190 || mX >= 300 || mY <= 65 + i * 10 || mY >= 65 + (i + 1) * 10) continue;
                if (this.commands[i].isEmpty()) {
                    this.drawStringTrimmed(matrices, gui, (ITextProperties)Translator.translatable("hqm.commandEdit.deleted", new Object[0]), 190, 65 + i * 10, 0xF76767);
                    continue;
                }
                this.drawStringTrimmed(matrices, gui, Translator.plain(this.commands[i]), 190, 65 + i * 10, this.edited[i] ? 16362362 : 0x969696);
            }
        }
        if (this.added != null && !this.added.isEmpty()) {
            this.drawStringTrimmed(matrices, gui, Translator.plain(this.added), 190, 65 + i * 10, 5938016);
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        int i;
        super.onClick(gui, mX, mY, b);
        if (this.commands != null && this.commands.length > 0) {
            for (i = 0; i < this.commands.length; ++i) {
                if (mX <= 190 || mX >= 300 || mY <= 65 + i * 10 || mY >= 65 + (i + 1) * 10) continue;
                if (this.id == i) {
                    return;
                }
                if (this.id < 0) {
                    this.added = this.text.getText();
                } else if (!this.commands[this.id].equals(this.text.getText())) {
                    this.edited[this.id] = true;
                    this.commands[this.id] = this.text.getText();
                }
                this.id = i;
                this.text.setTextAndCursor(gui, this.commands[this.id]);
            }
        }
        if (mX > 190 && mX < 300 && mY > 65 + i * 10 && mY < 65 + (i + 1) * 10) {
            if (this.id == -1) {
                return;
            }
            if (this.commands != null) {
                this.commands[this.id] = this.text.getText();
            }
            this.id = -1;
            this.text.setTextAndCursor(gui, this.added);
        }
    }

    private void drawStringTrimmed(MatrixStack matrices, GuiBase gui, ITextProperties text, int x, int y, int colour) {
        final CharacterLimitingVisitor characterLimitingVisitor = new CharacterLimitingVisitor(25);
        text = text.func_230439_a_((ITextProperties.IStyledTextAcceptor)new ITextProperties.IStyledTextAcceptor<ITextProperties>(){
            private final TextPropertiesManager collector = new TextPropertiesManager();

            public Optional<ITextProperties> accept(Style style, String string) {
                characterLimitingVisitor.resetLength();
                if (!TextProcessing.func_238346_c_((String)string, (Style)style, (ICharacterConsumer)characterLimitingVisitor)) {
                    String string2 = string.substring(0, characterLimitingVisitor.getLength());
                    if (!string2.isEmpty()) {
                        this.collector.func_238155_a_(ITextProperties.func_240653_a_((String)string2, (Style)style));
                    }
                    return Optional.of(this.collector.func_238156_b_());
                }
                if (!string.isEmpty()) {
                    this.collector.func_238155_a_(ITextProperties.func_240653_a_((String)string, (Style)style));
                }
                return Optional.empty();
            }
        }, Style.field_240709_b_).orElse(text);
        gui.drawString(matrices, text, x, y, colour);
    }

    static class CharacterLimitingVisitor
    implements ICharacterConsumer {
        private int widthLeft;
        private int length;

        public CharacterLimitingVisitor(int maxWidth) {
            this.widthLeft = maxWidth;
        }

        public boolean accept(int i, Style style, int j) {
            --this.widthLeft;
            if ((float)this.widthLeft >= 0.0f) {
                this.length = i + Character.charCount(j);
                return true;
            }
            return false;
        }

        public int getLength() {
            return this.length;
        }

        public void resetLength() {
            this.length = 0;
        }
    }
}

