/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.LargeButton;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiEditMenu {
    private static final int CHECK_BOX_SRC_X = 192;
    private static final int CHECK_BOX_SRC_Y = 102;
    private static final int CHECK_BOX_SIZE = 7;
    protected List<LargeButton> buttons = new ArrayList<LargeButton>();
    protected PlayerEntity player;
    protected List<CheckBox> checkboxes;
    private boolean hasButtons;

    protected GuiEditMenu(GuiBase gui, PlayerEntity player) {
        this.player = player;
        this.checkboxes = new ArrayList<CheckBox>();
    }

    protected GuiEditMenu(GuiBase gui, PlayerEntity player, boolean isControlOnFirstPage) {
        this(gui, player);
        this.hasButtons = true;
        int xOffset = isControlOnFirstPage ? 0 : 145;
        this.buttons.add(new LargeButton("hqm.edit.ok", xOffset + 40, 200){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenu.this.save(gui);
                GuiEditMenu.this.close(gui);
            }
        });
        this.buttons.add(new LargeButton("hqm.edit.cancel", xOffset + 100, 200){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiEditMenu.this.close(gui);
            }
        });
    }

    public void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        for (LargeButton button : this.buttons) {
            if (!button.isVisible(gui, null)) continue;
            button.draw(matrices, gui, this.player, mX, mY);
        }
        for (CheckBox checkbox : this.checkboxes) {
            checkbox.draw(matrices, gui, mX, mY);
        }
    }

    public void renderTooltip(MatrixStack matrices, GuiBase gui, int mX, int mY) {
        for (LargeButton button : this.buttons) {
            if (!button.isVisible(gui, null)) continue;
            button.renderTooltip(matrices, gui, this.player, mX, mY);
        }
    }

    public void onClick(GuiBase gui, int mX, int mY, int b) {
        if (!this.hasButtons && b == 1) {
            this.save(gui);
            this.close(gui);
            return;
        }
        for (LargeButton button : this.buttons) {
            if (!button.inButtonBounds(gui, mX, mY) || !button.isVisible(gui, null) || !button.isEnabled(gui, null)) continue;
            button.onClick(gui, this.player);
        }
        for (CheckBox checkbox : this.checkboxes) {
            checkbox.onClick(gui, mX, mY);
        }
    }

    public void close(GuiBase gui) {
        gui.setEditMenu(null);
    }

    public void onKeyStroke(GuiBase gui, char c, int k) {
    }

    public void onDrag(GuiBase gui, int mX, int mY) {
    }

    public void onRelease(GuiBase gui, int mX, int mY) {
    }

    public void onScroll(GuiBase gui, double mX, double mY, double scroll) {
    }

    public abstract void save(GuiBase var1);

    public boolean doesRequiredDoublePage() {
        return true;
    }

    public boolean hasButtons() {
        return this.hasButtons;
    }

    public abstract class CheckBox {
        private int x;
        private int y;
        private String name;
        private List<ITextProperties> cached;
        private int width = Integer.MAX_VALUE;

        protected CheckBox(String name, int x, int y) {
            this.x = x;
            this.y = y;
            this.name = name;
        }

        protected CheckBox(String name, int x, int y, int width) {
            this(name, x, y);
            this.width = width;
        }

        protected void draw(MatrixStack matrices, GuiBase gui, int mX, int mY) {
            if (!this.isVisible()) {
                return;
            }
            if (this.cached == null) {
                this.cached = gui.getLinesFromText((ITextProperties)Translator.translatable(this.name, new Object[0]), 0.7f, this.width);
            }
            boolean selected = this.getValue();
            boolean hover = gui.inBounds(this.x, this.y, 7, 7, mX, mY);
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            gui.drawRect(this.x, this.y, 192 + (selected ? 7 : 0), 102 + (hover ? 7 : 0), 7, 7);
            gui.drawString(matrices, this.cached, this.x + 12, this.y + 2, 0.7f, 0x404040);
        }

        protected void onClick(GuiBase gui, int mX, int mY) {
            if (this.isVisible() && gui.inBounds(this.x, this.y, 7, 7, mX, mY)) {
                this.setValue(!this.getValue());
            }
        }

        protected boolean isVisible() {
            return true;
        }

        public abstract boolean getValue();

        public abstract void setValue(boolean var1);
    }
}

