/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextBoxLogic {
    private static final int TEXT_HEIGHT = 9;
    protected int cursor;
    protected int cursorPositionX;
    protected boolean updatedCursor;
    private String text;
    private List<String> lines;
    private int cursorPositionY;
    private boolean multiLine;
    private int width;
    private float mult = 1.0f;
    private int maxLength = Integer.MAX_VALUE;
    private int cursorLine;

    public TextBoxLogic(GuiBase gui, String text, int width, boolean multiLine) {
        this.width = width;
        this.multiLine = multiLine;
        this.text = text == null ? "" : text;
        this.textChanged(gui);
        this.resetCursor();
    }

    public int getCursorLine(GuiBase gui) {
        this.recalculateCursor(gui);
        return this.cursorLine;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public float getMult() {
        return this.mult;
    }

    public void setMult(float mult) {
        this.mult = mult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addText(GuiBase gui, String str) {
        String newText = this.text.substring(0, this.cursor) + str + this.text.substring(this.cursor);
        if ((newText = this.getValidText(newText)).length() <= this.maxLength && (this.multiLine || (float)gui.getStringWidth(newText) * this.mult <= (float)this.width)) {
            this.text = newText;
            this.moveCursor(gui, str.length());
            this.textChanged(gui);
        }
    }

    private String getValidText(String txt) {
        StringBuilder builder = new StringBuilder();
        for (char c : txt.toCharArray()) {
            if (!this.isCharacterValid(c, builder.toString())) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void deleteText(GuiBase gui, int direction) {
        if (this.cursor + direction >= 0 && this.cursor + direction <= this.text.length()) {
            if (direction > 0) {
                this.text = this.text.substring(0, this.cursor) + this.text.substring(this.cursor + 1);
            } else {
                this.text = this.text.substring(0, this.cursor - 1) + this.text.substring(this.cursor);
                this.moveCursor(gui, direction);
            }
            this.textChanged(gui);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void moveCursor(GuiBase gui, int steps) {
        this.cursor += steps;
        this.updateCursor();
    }

    public void textChanged(GuiBase gui) {
        this.lines = gui.getLinesFromText(Translator.plain(this.text), this.mult, this.width).stream().map(Translator::rawString).collect(Collectors.toList());
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String getText() {
        return this.text;
    }

    public int getCursorPositionX(GuiBase gui) {
        this.recalculateCursor(gui);
        return this.cursorPositionX;
    }

    public int getCursorPositionY(GuiBase gui) {
        this.recalculateCursor(gui);
        return this.cursorPositionY;
    }

    public void recalculateCursor(GuiBase gui) {
        if (this.updatedCursor) {
            if (this.multiLine) {
                int tmpCursor = this.cursor;
                for (int i = 0; i < this.lines.size(); ++i) {
                    if (tmpCursor <= this.lines.get(i).length()) {
                        this.cursorPositionX = (int)(this.mult * (float)gui.getStringWidth(this.lines.get(i).substring(0, tmpCursor)));
                        this.cursorPositionY = (int)((float)(9 * i) * this.mult);
                        this.cursorLine = i;
                        break;
                    }
                    tmpCursor -= this.lines.get(i).length();
                }
            } else {
                this.cursorPositionX = (int)(this.mult * (float)gui.getStringWidth(this.text.substring(0, this.cursor)));
                this.cursorPositionY = 0;
            }
            this.updatedCursor = false;
        }
    }

    public void setText(GuiBase gui, String text) {
        this.text = this.getValidText(text);
        this.textChanged(gui);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onKeyStroke(GuiBase gui, char c, int k) {
        if (k == 263) {
            this.moveCursor(gui, -1);
        } else if (k == 262) {
            this.moveCursor(gui, 1);
        } else if (k == 259) {
            this.deleteText(gui, -1);
        } else if (k == 261) {
            this.deleteText(gui, 1);
        } else if (k == 335 || k == 257) {
            this.addText(gui, "\\n");
        } else if (k == 268) {
            this.cursor = 0;
            this.updateCursor();
        } else if (k == 269) {
            this.cursor = this.text.length();
            this.updateCursor();
        } else if (this.isCharacterValid(c, this.getText())) {
            this.addText(gui, Character.toString(c));
        }
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
        this.updateCursor();
    }

    protected boolean isCharacterValid(char c, String rest) {
        return SharedConstants.func_71566_a((char)c);
    }

    private void updateCursor() {
        if (this.cursor < 0) {
            this.cursor = 0;
        } else if (this.cursor > this.text.length()) {
            this.cursor = this.text.length();
        }
        this.updatedCursor = true;
    }

    public void resetCursor() {
        this.cursor = this.text.length();
        this.updatedCursor = true;
    }

    public void setTextAndCursor(GuiBase gui, String s) {
        this.setText(gui, s);
        this.resetCursor();
    }
}

