/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ScrollBar {
    private static final int SCROLL_WIDTH = 7;
    private static final int SCROLL_BAR_WIDTH = 5;
    private static final int SCROLL_BAR_HEIGHT = 6;
    private static final int SCROLL_BAR_SRC_X = 250;
    private static final int SCROLL_BAR_SRC_Y = 167;
    private int x;
    private int y;
    private int h;
    private int u;
    private int v;
    private int left;
    private double scroll;
    private boolean isScrolling;

    public ScrollBar(int x, int y, int h, int u, int v, int left) {
        this.x = x;
        this.y = y;
        this.h = h;
        this.u = u;
        this.v = v;
        this.left = left;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isVisible(GuiBase gui) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void onUpdate() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiBase gui) {
        if (this.isVisible(gui)) {
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            gui.drawRect(this.x, this.y, this.u, this.v, 7, this.h);
            gui.drawRect(this.x + 1, (int)((double)(this.y + 1) + this.scroll), 250, 167, 5, 6);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClick(GuiBase gui, int mX, int mY) {
        if (this.isVisible(gui) && gui.inBounds(this.x, this.y, 7, this.h, mX, mY)) {
            this.isScrolling = true;
            this.updateScroll(mY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDrag(GuiBase gui, int mX, int mY) {
        if (this.isVisible(gui)) {
            this.updateScroll(mY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRelease(GuiBase gui, int mX, int mY) {
        if (this.isVisible(gui)) {
            this.updateScroll(mY);
            this.isScrolling = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateScroll(int mY) {
        if (this.isScrolling) {
            this.setScroll(mY - this.y - 3);
        }
    }

    public float getScroll() {
        return (float)this.scroll / (float)(this.h - 6 - 2);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setScroll(double newScroll) {
        double old = this.scroll;
        this.scroll = newScroll;
        if (this.scroll < 0.0) {
            this.scroll = 0.0;
        } else if (this.scroll > (double)(this.h - 6 - 2)) {
            this.scroll = this.h - 6 - 2;
        }
        if (this.scroll != old) {
            this.onUpdate();
        }
    }

    public void resetScroll() {
        this.scroll = 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScroll(GuiBase gui, double mX, double mY, double scroll) {
        if (this.isVisible(gui) && gui.inBounds(this.left, this.y, this.x + 7 - this.left, this.h, mX, mY)) {
            this.setScroll(this.scroll - scroll);
        }
    }
}

