/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class LargeButton {
    private static final int BUTTON_SRC_X = 54;
    private static final int BUTTON_SRC_Y = 235;
    private static final int BUTTON_WIDTH = 57;
    private static final int BUTTON_HEIGHT = 18;
    private String name;
    private String description;
    private int x;
    private int y;
    private List<ITextProperties> lines;

    public LargeButton(String name, int x, int y) {
        this.name = name;
        this.x = x;
        this.y = y;
    }

    public LargeButton(String name, String description, int x, int y) {
        this(name, x, y);
        this.description = description;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean inButtonBounds(GuiBase gui, int mX, int mY) {
        return gui.inBounds(this.x, this.y, 57, 18, mX, mY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract boolean isEnabled(GuiBase var1, PlayerEntity var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract boolean isVisible(GuiBase var1, PlayerEntity var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onClick(GuiBase var1, PlayerEntity var2);

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrices, GuiBase gui, PlayerEntity player, int mX, int mY) {
        if (this.isVisible(gui, player)) {
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            boolean enabled = this.isEnabled(gui, player);
            gui.drawRect(this.x, this.y, 54 + (enabled && this.inButtonBounds(gui, mX, mY) ? 57 : 0), 235, 57, 18);
            gui.drawCenteredString(matrices, this.getName(), this.x, this.y, 0.7f, 57, 18, enabled ? 0x404040 : 0xA0A070);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(MatrixStack matrices, GuiBase gui, PlayerEntity player, int mX, int mY) {
        if (this.isVisible(gui, player) && this.description != null && this.inButtonBounds(gui, mX, mY)) {
            if (this.lines == null) {
                this.lines = gui.getLinesFromText(this.getDescription(), 1.0f, 200);
            }
            gui.func_238654_b_(matrices, LanguageMap.func_74808_a().func_244260_a(this.lines), mX + gui.left, mY + gui.top);
        }
    }

    protected ITextProperties getName() {
        return Translator.translatable(this.name, new Object[0]);
    }

    protected ITextProperties getDescription() {
        return Translator.translatable(this.description, new Object[0]);
    }
}

