/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.bag.Group;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.items.BagItem;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;

public class GuiReward
extends GuiBase {
    public static final ResourceLocation TEXTURE = ResourceHelper.getResource("reward");
    public static final ResourceLocation C_TEXTURE = ResourceHelper.getResource("c_reward");
    private static final int ITEMS_PER_LINE = 7;
    private static final int ITEM_SIZE = 16;
    private static final int ITEM_MARGIN = 5;
    private static final int TOP_HEIGHT = 52;
    private static final int MIDDLE_HEIGHT = 22;
    private static final int BOTTOM_HEIGHT = 24;
    private static final int TITLE_HEIGHT = 25;
    private static final int TOP_SRC_Y = 0;
    private static final int MIDDLE_SRC_Y = 67;
    private static final int BOTTOM_SRC_Y = 107;
    private static final int TEXTURE_WIDTH = 170;
    private Group group;
    private int lines;
    private List<Reward> rewards;
    private String statisticsText;

    public GuiReward(Group group, int bagTier, PlayerEntity player) {
        super(NarratorChatListener.field_216868_a);
        this.group = group;
        this.rewards = new ArrayList<Reward>();
        int totalWeight = 0;
        for (Group other : Group.getGroups().values()) {
            if (!other.isValid(player)) continue;
            totalWeight += other.getTier().getWeights()[bagTier];
        }
        int myWeight = group.getTier().getWeights()[bagTier];
        float chance = (float)myWeight / (float)totalWeight;
        this.statisticsText = I18n.func_135052_a((String)"hqm.rewardGui.chance", (Object[])new Object[]{Float.valueOf((float)((int)(chance * 10000.0f)) / 100.0f)});
        this.lines = (int)Math.ceil((float)group.getItems().size() / 7.0f);
        for (int i = 0; i < this.lines; ++i) {
            int y = 52 + 22 * i + 3;
            int itemsInLine = Math.min(group.getItems().size() - i * 7, 7);
            for (int j = 0; j < itemsInLine; ++j) {
                int x = (170 - (itemsInLine * 16 + (itemsInLine - 1) * 5)) / 2 + j * 21;
                ItemStack stack = (ItemStack)group.getItems().get(i * 7 + j);
                if (stack.func_190926_b()) continue;
                this.rewards.add(new Reward(stack, x, y));
            }
        }
    }

    public static void open(PlayerEntity player, UUID groupId, int bag, int[] limits) {
        Group rewardGroup = Group.getGroups().get(groupId);
        int i = 0;
        for (Group group : Group.getGroups().values()) {
            if (group.getLimit() == 0) continue;
            group.setRetrievalCount(player, limits[i++]);
        }
        if (BagItem.displayGui && rewardGroup != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiReward(rewardGroup, bag, player));
        }
    }

    public void func_230430_a_(MatrixStack matrices, int mX0, int mY0, float f) {
        this.applyColor(-1);
        ResourceHelper.bindResource(TEXTURE);
        int height = 52 + 22 * this.lines + 24;
        this.left = (this.field_230708_k_ - 170) / 2;
        this.top = (this.field_230709_l_ - height) / 2;
        this.drawRect(0, 0, 0, 0, 170, 52);
        for (int i = 0; i < this.lines; ++i) {
            this.drawRect(0, 52 + i * 22, 0, 67, 170, 22);
        }
        this.drawRect(0, 52 + this.lines * 22, 0, 107, 170, 24);
        int mX = mX0 - this.left;
        int mY = mY0 - this.top;
        String title = this.group.getDisplayName();
        if (HQMConfig.getInstance().Loot.ALWAYS_USE_TIER || title == null || title.isEmpty()) {
            title = I18n.func_135052_a((String)"hqm.rewardGui.tierReward", (Object[])new Object[]{this.group.getTier().getName()});
        }
        this.drawCenteredString(matrices, ITextProperties.func_240653_a_((String)title, (Style)Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)(this.group.getTier().getColor().getHexColor() & 0xFFFFFF)))), 0, 0, 1.0f, 170, 25, 0x404040);
        this.drawCenteredString(matrices, Translator.plain(this.statisticsText), 0, 25, 0.7f, 170, 27, 0x707070);
        this.drawCenteredString(matrices, (ITextProperties)Translator.translatable("hqm.rewardGui.close", new Object[0]), 0, 52 + this.lines * 22, 0.7f, 170, 24, 0x707070);
        for (Reward reward : this.rewards) {
            try {
                this.drawItemStack(reward.stack, reward.x, reward.y, true);
                itemRenderer.func_180453_a(this.field_230712_o_, reward.stack, reward.x + this.left + 1, reward.y + this.top + 1, "");
            }
            catch (Throwable throwable) {}
        }
        RenderSystem.disableLighting();
        for (Reward reward : this.rewards) {
            if (!this.inBounds(reward.x, reward.y, 16, 16, mX, mY)) continue;
            try {
                if (Screen.func_231173_s_()) {
                    this.func_230457_a_(matrices, reward.stack, mX0, mY0);
                    continue;
                }
                ArrayList<IReorderingProcessor> str = new ArrayList<IReorderingProcessor>();
                try {
                    List info = reward.stack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(this.field_230706_i_.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                    if (info.size() > 0) {
                        str.add(LanguageMap.func_74808_a().func_241870_a((ITextProperties)info.get(0)));
                        if (info.size() > 1) {
                            str.add(LanguageMap.func_74808_a().func_241870_a((ITextProperties)Translator.translatable("hqm.rewardGui.shiftInfo", GuiColor.GRAY, new Object[0])));
                        }
                    }
                    this.func_238654_b_(matrices, str, mX0, mY0);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean func_231044_a_(double mX0, double mY0, int b) {
        Minecraft.func_71410_x().func_147108_a(null);
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private static class Reward {
        private ItemStack stack;
        private int x;
        private int y;

        private Reward(ItemStack stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }
    }
}

